/*
    Copyright 2006,2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include <zlib.h>       // -lz
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define sleepms sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define sleepms(X)  usleep(X * 1000)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;
typedef uint64_t    u64;



#define VER         "0.2.2e"
#define ZLIBMAX(X)  ((X) + ((X) / 1000) + 12)

#ifndef LITTLE_ENDIAN
    #define LITTLE_ENDIAN   0
    #define BIG_ENDIAN      1
#endif



#include "udpspoof.h"
u32 randit(u32 *rnd);
void recvshow(int sd);
u8 *load_file(int offset, u8 *filename, int *size, int *contentsize);
u8 *load_bstring(int offset, u8 *bstring, int *size, int len, int *contentsize);
int hex2byte(u8 *hex);
u8 *load_xstring(int offset, u8 *xstring, int *size, int *contentsize);
int create_socket(void);
u8 get_byte(u8 *data);
int get_num(u8 *data);
int create_rand_byte(u8 *data, int len, u32 *seed);
int putxx(u8 *data, u32 num, int bits, int endian);
int zip(z_stream *z, u8 *in, u32 insz, u8 *out, u32 outsz);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    z_stream            z;
    struct  sockaddr_in peer,
                        peerl;
    u32     seed,
            offset      = 0,
            Xnumber     = 0,
            Xmaxnumber  = 0;
    int     sd          = 0,
            on          = 1,
            i,
            zlen,
            size,
            sendsize,
            zoffset     = 0,
            Xoffset     = 0,
            randport    = 0,
            randbyte    = 0,
            loop        = 0,
            loopms      = 0,
            chr         = 0,
            upsize      = 0,
            Xbits       = 0,
            Xendian     = 0,
            zbits       = 0,
            dumpsend    = 0,
            dumprecv    = 0,
            quiet       = 0,
            contentsize = 0;
    u16     port,
            sport       = 0;
    u8      *buff       = NULL,
            *content    = NULL,
            *sendbuff   = NULL,
            *bstring    = NULL,
            *xstring    = NULL,
            *filename   = NULL,
            *spoof      = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "UDPSZ "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s [options] <host> <port> <pck_size>\n"
            "\n"
            "Options:\n"
            "-b BYTE    fill the packet with byte BYTE, which can be a char or a hex\n"
            "           example: -b a   or   -b 0x61   or   -b 61\n"
            "-r         random packet content\n"
            "-s         packet filled with incremental byte (suggested -b and -l)\n"
            "-p PORT    use source port PORT\n"
            "-R         random source port (suggested -l)\n"
            "-S         sequential source port (needs -l)\n"
            "-x         the size of the packet will go from 0 to pck_size (needs -l)\n"
            "-X O B E V special number content, the initial bytes of the packet (max 4)\n"
            "           are a number of B bits (from 8 to 32) of endianess E (l/i or b/n)\n"
            "           at offset O of the packet and incremented at each send (needs -l)\n"
            "           V is the initial value assigned to this number (e.g. -X 0 32 i 0)\n"
            "-z O W     compress the data in the packet at offset O using W windowbits\n"
            "           (15 is the most commonly used or -15)\n"
            "-f FILE    load the content of the packet from FILE, the size will be\n"
            "           truncated at pck_size, set it to -1 for using the real file size\n"
            "-c DATA    as above but the content is specified by DATA (e.g. -c \"bye all\")\n"
            "-C XDATA   as above but in hex format (e.g. -C \"12 34 00 56 789abcdef\")\n"
            "-o OFF     place the data of the -f/-c/-C options at offset OFF of the packet\n"
            "-l MS      send infinite packets with a delay of MS milliseconds\n"
            "-d         show the hex dump of each packet (debug)\n"
            "-D         try to receive a reply packet and visualize it (debug)\n"
            "-q         don't show the dots for each packet sent\n"
            "-P IP      spoof the source IP address of the packets, use IP 0 for random.\n"
            "           note that in some situations is not possible to send packets bigger\n"
            "           than a certain size so is better to stay under 1400 bytes\n"
            "           if no port is specified (-p/-R/-S) will be used the source port 0\n"
            "\n"
            "Most of the commands can be combined together for building custom packets\n"
            "\n", argv[0]);
        exit(1);
    }

    argc -= 3;
    for(i = 1; i < argc; i++) {
        if(((argv[i][0] != '-') && (argv[i][0] != '/')) || (strlen(argv[i]) != 2)) {
            printf("\nError: wrong argument (%s)\n", argv[i]);
            exit(1);
        }
        switch(argv[i][1]) {
            case 'b': chr       = get_byte(argv[++i]);  break;
            case 'r': randbyte  = 1;                    break;
            case 's': randbyte  = 2;                    break;
            case 'p': sport     = get_num(argv[++i]);   break;
            case 'R': randport  = 1;                    break;
            case 'S': randport  = 2;                    break;
            case 'f': filename  = argv[++i];            break;
            case 'x': upsize    = 1;                    break;
            case 'X': {
                Xoffset         = get_num(argv[++i]);
                Xbits           = get_num(argv[++i]);
                Xmaxnumber      = ((u64)1 << Xbits) - 1;
                Xendian         = argv[++i][0];
                Xnumber         = get_num(argv[++i]);
                if((tolower(Xendian) == 'l') || (tolower(Xendian) == 'i')) {
                    Xendian = LITTLE_ENDIAN;
                } else {
                    Xendian = BIG_ENDIAN;
                }
                } break;
            case 'z': {
                zoffset         = get_num(argv[++i]);
                zbits           = get_num(argv[++i]);
                } break;
            case 'c': bstring   = argv[++i];            break;
            case 'C': xstring   = argv[++i];            break;
            case 'o': offset    = get_num(argv[++i]);   break;
            case 'l': {
                loop            = 1;
                loopms          = get_num(argv[++i]);
                } break;
            case 'd': dumpsend  = 1;                    break;
            case 'D': dumprecv  = 1;                    break;
            case 'q': quiet     = 1;                    break;
            case 'P': spoof     = argv[++i];            break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                } break;
        }
        if(i >= argc) {
            printf("\nError: recheck your command-line arguments\n");
            exit(1);
        }
    }

    port                  = get_num(argv[argc + 1]);
    size                  = get_num(argv[argc + 2]);

    peer.sin_addr.s_addr  = resolv(argv[argc]);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(0);
    peerl.sin_family      = AF_INET;
    if(spoof) {
        peerl.sin_addr.s_addr = resolv(spoof);
        if((peerl.sin_addr.s_addr == INADDR_NONE) || (peerl.sin_addr.s_addr == INADDR_ANY)) spoof = "";
    }

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    seed = time(NULL);
    randit(&seed);

    if(filename) {
        buff = load_file(offset, filename, &size, &contentsize);
    } else if(bstring) {
        buff = load_bstring(offset, bstring, &size, -1, &contentsize);
    } else if(xstring) {
        buff = load_xstring(offset, xstring, &size, &contentsize);
    }
    if(size < 0) {
        printf("\nError: pck_size must be major or equal than 0 and max 65535\n");
        exit(1);
    }
    if(buff) {
        if(contentsize > size) contentsize = size;
        content = calloc(contentsize, 1);
        if(!content) std_err();
        memcpy(content, buff, contentsize);
    } else {
        buff = calloc(size, 1);
        if(!buff) std_err();
        if(!randbyte) memset(buff, chr, size);
    }
    printf("- packet size:  %d\n", size);

    if((Xbits < 0) || (Xbits > 32)) {
        printf("\nError: wrong -X bits value\n");
        exit(1);
    }
    if(Xbits) {
        i = Xbits >> 3;
        if((size - Xoffset) < i) {
            size = Xoffset + i;
            printf("- corrected packet size:  %d\n", size);
            buff = realloc(buff, size);
            if(!buff) std_err();
        }
    }
    if((Xoffset < 0) || (Xoffset > size)) {
        printf("\nError: wrong -X offset value\n");
        exit(1);
    }
    if((zoffset < 0) || (zoffset > size)) {
        printf("\nError: wrong -z offset value\n");
        exit(1);
    }

    if(zbits) {
        z.zalloc = (alloc_func)0;
        z.zfree  = (free_func)0;
        z.opaque = (voidpf)0;
        if(deflateInit2(&z, Z_BEST_COMPRESSION, Z_DEFLATED, zbits, Z_BEST_COMPRESSION, Z_DEFAULT_STRATEGY) != Z_OK) {
            printf("\nError: zlib initialization error\n");
            exit(1);
        }
        sendbuff = calloc(ZLIBMAX(size), 1);
        if(!sendbuff) std_err();
    }

    if(randport) {
        peerl.sin_port      = htons(~seed);
    } else {
        sd = create_socket();
        if(sport) { // source port must be ever different than zero or the OS assigns the first free one
            peerl.sin_port  = htons(sport);
            printf("- source port:  %hu\n", ntohs(peerl.sin_port));
            if(!spoof) {
                setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
                if(bind(sd, (struct sockaddr *)&peerl, sizeof(peerl))
                  < 0) std_err();
            }
        }
    }

    sendsize = size;
    if(upsize) sendsize = 0;

    printf("- send packets:\n");
    for(;;) {
        if(randport) {
            sd = create_socket();
            do {
                if(randport == 2) {                 // sequential
                    peerl.sin_port = htons(sport++);
                } else {
                    peerl.sin_port = randit(&seed);
                }
                if(spoof) break;                
            } while(bind(sd, (struct sockaddr *)&peerl, sizeof(peerl)) < 0);
        }

        if(randbyte == 0) {
            memset(buff, chr, size);
        } else if(randbyte == 1) {
            create_rand_byte(buff, size, &seed);
        } else if(randbyte == 2) {
            memset(buff, chr++, size);
        }
        if(content) memcpy(buff, content, contentsize);
        if(Xbits) {
            putxx(buff + Xoffset, Xnumber, Xbits, Xendian);
        }
        zlen = 0;
        if(zbits) {
            memcpy(sendbuff, buff, sendsize);
            if(sendsize >= zoffset) {
                zlen = sendsize - zoffset;
                zlen = zip(&z, buff + zoffset, zlen, sendbuff + zoffset, ZLIBMAX(zlen));
                zlen = (zoffset + zlen) - sendsize;
            }
        } else {
            sendbuff = buff;    // in case of realloc and so on... useless but saves memory
        }

        if(dumpsend) {
            printf("%u bytes\n", sendsize + zlen);
            show_dump(sendbuff, sendsize + zlen, stdout);
        } else {
            if(!dumprecv && !quiet) fputc('.', stdout);
        }

        if(spoof) {
            if(!spoof[0]) peerl.sin_addr.s_addr = randit(&seed);
            if(udpspoof(peerl.sin_addr.s_addr, peerl.sin_port, peer.sin_addr.s_addr, peer.sin_port, sendbuff, sendsize + zlen) < 0) {
                printf("\n"
                    "Error: spoofing failed, are you root or admin?\n"
                    "       does your OS support RAW sockets? has it limitations on spoofing?\n"
                    "       possible causes: OS or OS configuration, network configuration, being\n"
                    "       behind a router/NAT and others...\n"
                    "\n"
                    "       if the problem is caused by the Operating System a solution can be the\n"
                    "       usage of another OS via a Virtual Machine (on the same computer where I\n"
                    "       have these problems has been enough to launch Windows 2003 or Linux\n"
                    "       through VirtualBox for bypassing the spoofing limitations of the OS)\n"
                    );
                exit(1);
            }
        } else {
            if(sendto(sd, sendbuff, sendsize + zlen, 0, (struct sockaddr *)&peer, sizeof(peer))
             < 0) std_err();
        }

        if(dumprecv) {
            recvshow(sd);
        }

        if(randport) close(sd);

        if(!loop) break;
        if(upsize) {
            if(sendsize >= size) break;
            sendsize++;
        }
        if(Xbits) {
            if(Xnumber == Xmaxnumber) break;
            Xnumber++;
        }
        sleepms(loopms);
    }

    if(!randport) close(sd);
    free(buff);
    if(zbits) inflateEnd(&z);
    printf("\n- finished\n");
    return(0);
}



u32 randit(u32 *rnd) {
    *rnd = (*rnd * 0x343FD) + 0x269EC3;
    *rnd = ~((*rnd >> 1) - 1);  // *rnd >>= 1 was enough
    return(*rnd);
}



void recvshow(int sd) {
    int     len;
    static u8   *buff = NULL;

    if(timeout(sd, 1) < 0) return;

    if(!buff) {
        buff = malloc(0xffff);
        if(!buff) std_err();
    }

    len = recvfrom(sd, buff, 0xffff, 0, NULL, NULL);
    if(len < 0) return;
    show_dump(buff, len, stdout);
}



u8 *load_file(int offset, u8 *filename, int *size, int *contentsize) {
    struct  stat    xstat;
    int     len;
    FILE    *fd;
    u8      *buff;

    if(offset < 0) exit(1);
    printf("- load file:    %s\n", filename);
    fd = fopen(filename, "rb");
    if(!fd) std_err();

    fstat(fileno(fd), &xstat);
    len = xstat.st_size;
    if(contentsize) *contentsize = len;
    if(*size < 0) *size = offset + len;

    buff = calloc(*size, 1);
    if(!buff) std_err();
    if(offset > *size) {
        return(buff);
    }
    if(len > (*size - offset)) len = *size - offset;

    fread(buff + offset, 1, len, fd);
    memset(buff + offset + len, 0, *size - (offset + len));
    fclose(fd);
    return(buff);
}



u8 *load_bstring(int offset, u8 *bstring, int *size, int len, int *contentsize) {
    u8      *buff;

    if(offset < 0) exit(1);
    if(len < 0) len = strlen(bstring);
    if(contentsize) *contentsize = len;
    if(*size < 0) *size = offset + len;

    buff = calloc(*size, 1);
    if(!buff) std_err();
    if(offset > *size) {
        return(buff);
    }
    if(len > (*size - offset)) len = *size - offset;

    memcpy(buff + offset, bstring, len);
    memset(buff + offset + len, 0, *size - (offset + len));
    return(buff);
}



int hex2byte(u8 *hex) {
    static const u8 hextable[256] =
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\xff\xff\xff\xff\xff\xff"
        "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff";

    if(hextable[hex[0]] > 15) return(-1);
    if(hextable[hex[1]] > 15) return(-1);
    return((hextable[hex[0]] << 4) | hextable[hex[1]]);
}



u8 *load_xstring(int offset, u8 *xstring, int *size, int *contentsize) {
    int     i,
            c,
            len;
    u8      *bstring,
            *p;

    len = strlen(xstring);
    bstring = malloc(len / 2);
    if(!bstring) std_err();

    p = bstring;
    for(i = 0; i < len; i++) {
        c = hex2byte(xstring + i);
        if(c < 0) continue;
        *p++ = c;
        i++;    // +2
    }

    len = p - bstring;
    if(contentsize) *contentsize = len;
    return(load_bstring(offset, bstring, size, len, contentsize));
}



int create_socket(void) {
    struct  linger  ling = {1,1};
    int     sd,
            on = 1;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof(on));
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    return(sd);
}



u8 get_byte(u8 *data) {
    int     chr;

    if(strlen(data) < 1)  return(0);
    if(strlen(data) == 1) return(data[0]);
    if(tolower(data[1]) == 'x') data += 2;
    sscanf(data, "%x", &chr);
    return(chr);
}



int get_num(u8 *data) {
    int     num;

    if(tolower(data[1]) == 'x') {
        sscanf(data + 2, "%x", &num);
    } else if(data[0] == '-') {
        sscanf(data, "%i", &num);
    } else {
        sscanf(data, "%u", &num);
    }
    return(num);
}



int create_rand_byte(u8 *data, int len, u32 *seed) {
    u32     rnd;
    u8      *p;

    rnd = *seed;
    p   = data;
    while(len--) {
        *p++ = randit(&rnd);
    }
    *seed = rnd;
    return(p - data);
}



int putxx(u8 *data, u32 num, int bits, int endian) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        if(endian == BIG_ENDIAN) {
            data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
        } else {
            data[i] = (num >> (i << 3)) & 0xff;
        }
    }
    return(bytes);
}



int zip(z_stream *z, u8 *in, u32 insz, u8 *out, u32 outsz) {
    deflateReset(z);

    z->next_in   = in;
    z->avail_in  = insz;
    z->next_out  = out;
    z->avail_out = outsz;
    if(deflate(z, Z_FINISH) != Z_STREAM_END) {
        printf("\nError: the compressed output is wrong or incomplete\n");
        exit(1);
    }
    return(z->total_out);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}




#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


