#!/bin/sh

# URLScan enumeration tool
#
# By Andy Davis
#
# Requires lwp-request (GET/POST) in the path
#

SERVER=$1
NAMEFILE=$2

if [ ! ${SERVER} ] ; then
  echo "Usage $0 <target web server> <file containing URL checks>"
  exit 1
fi

for NAME in `cat ${NAMEFILE}`

do
TEST=`GET -e "http://${SERVER}/${NAME}" 2>/dev/null | grep UrlScan`

if test -n "${TEST}"
then
echo ${NAME} - Filtered
else 
echo ${NAME} - \*\*\*\* Allowed \*\*\*\*
fi

done



