#include <stdio.h>

#include "SkCanvas.h"
#include "SkPath.h"
#include "SkBitmap.h"

int main(int argc, char * const argv[]) {

  SkBitmap bitmap;
  bitmap.allocN32Pixels(24, 24);
  SkCanvas canvas(bitmap);

  SkPaint paint;
  paint.setAntiAlias(true);
  paint.setStyle(SkPaint::kFill_Style);

  SkPath path;
  path.moveTo(0, 0);
  for(int i=0; i<1000; i++) {
    path.lineTo(0,0);
  }
  path.lineTo(2, 0 + 2*1e-28);
  path.lineTo(4, -1e-30 + 4*1e-28);
  path.lineTo(4, -2e-30 + 4*1e-28);
  path.lineTo(4.1, -2e-30 + 4.1*1e-28);
  path.lineTo(4.1, -1e-30 + 4.1*1e-28);
  path.lineTo(6, 0 + 6*1e-28);
  path.lineTo(10, -4e-30 + 10*1e-28);
  path.lineTo(14, 0 + 14*1e-28);
  path.lineTo(0.5, 1e-27 + 0.5*1e-28);
  path.close();

  if(path.isConvex()) {
    printf("convex\n");
  } else {
    printf("not convex\n");
  }

  SkMatrix m;
  m.setSkew(0, -1e-28);
  m.postScale(1, 1e30*0.25);
  m.postTranslate(0, 5);
  path.transform(m);

  // As demonstrated here
  if(path.isConvex()) {
    printf("convex\n");
  } else {
    printf("not convex\n");
  }

  canvas.drawPath(path, paint);

  printf("done\n");

  return 0;
}

