//Halflife GetInfo
//Linux version
//by Auriemma Luigi: bugtest at sitoverde.com

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>

#define BUFFSIZE	4096
#define PORT	27015
#define INFO	"\xff\xff\xff\xffinfostring\n"
#define PLAYERS	"\xff\xff\xff\xffplayers"
#define RULES	"\xff\xff\xff\xffrules"
#define END	0x5c	//"\"
#define OFFSET	23
#define DELAY	200000	//200 ms

void error_handle(int err);
char *get_token (char *buffer, char *token);

int main(int argc, char *argv[]) {
	setbuf(stdout, NULL);
	if(argc < 2) {
		printf("\nUsage: %s <host> [port(default %d)]\n", argv[0], PORT);
		exit(1);
	}

	unsigned char	buff[BUFFSIZE];
	struct	sockaddr_in peer;
	struct	hostent *hp;
	int	shandle,
		err,
		recvlen,
		players,
		i,
		j;

	if(inet_addr(argv[1]) == INADDR_NONE) {
                hp = gethostbyname(argv[1]);
		if(hp == 0) error_handle(-1);
                else peer.sin_addr = *((struct in_addr *)hp->h_addr);
        }
                else peer.sin_addr.s_addr = inet_addr(argv[1]);
	if(!argv[2]) peer.sin_port = htons(PORT);
		else peer.sin_port = htons(atoi(argv[2]));
	peer.sin_family = PF_INET;
	recvlen = sizeof(peer);

	memset(buff, 0x00, BUFFSIZE);
	shandle = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	error_handle(shandle);
	err = sendto(shandle, INFO, sizeof(INFO), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);

	players = atoi(get_token(buff, "\\players\\"));
	printf("\n");
	printf("Address:            %s\n", get_token(buff, "\\address\\"));
	printf("Hostname:           %s\n", get_token(buff, "\\hostname\\"));
	printf("Description (game): %s\n", get_token(buff, "\\description\\"));
	printf("Map name:           %s\n", get_token(buff, "\\map\\"));
	printf("Protocol:           %s\n", get_token(buff, "\\protocol\\"));
	printf("Players:            %d\n", players);
	printf("Max players:        %s\n", get_token(buff, "\\max\\"));
	printf("Secure:             %s\n", get_token(buff, "\\secure\\"));
	printf("Operating System:   %s\n", get_token(buff, "\\os\\"));
	printf("Password protected: %s\n", get_token(buff, "\\password\\"));
	printf("Type:               %s\n", get_token(buff, "\\type\\"));
	printf("GameDirectory:      %s\n", get_token(buff, "\\gamedir\\"));
	printf("Lan:                %s\n", get_token(buff, "\\lan\\"));
	printf("Proxy Target:       %s\n", get_token(buff, "\\proxytarget\\"));
	printf("cldll:              %s\n", get_token(buff, "\\cldll\\"));
	printf("SVonly:             %s\n", get_token(buff, "\\svonly\\"));
	printf("Mod Version:        %s\n", get_token(buff, "\\modversion\\"));
	printf("Proxy Address:      %s\n", get_token(buff, "\\proxyaddress\\"));
	printf("\n");

	usleep(DELAY);

	memset(buff, 0x00, BUFFSIZE);
	err = sendto(shandle, PLAYERS, sizeof(PLAYERS), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	printf("Players:\n");
	for(i = 0; i < players; i++) {
		err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
		error_handle(err);
		printf("%d: %s\n", i, buff + 7);
	}

	usleep(DELAY);

	memset(buff, 0x00, BUFFSIZE);
	shandle = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	error_handle(shandle);
	err = sendto(shandle, RULES, sizeof(RULES), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	j = 1;
	for(i = 0; i < err; i++) {
		if((buff[i] == 0x00) && (j == 1)) {
			buff[i] = '\n';
			j = 0;
		}
		if((buff[i] == 0x00) && (j == 0)) {
			buff[i] = ' ';
			j = 1;
		}
	}
	printf("\nRules: \n%s", buff + 7);

	close(shandle);
	return(0);
}

void error_handle(int err) {
	if(err < 0) {
		perror("\nError");
		exit(1);
	}
}

char *get_token (char *buffer, char *token) {
        char *stri, *strf;
	strf = strchr(buffer + OFFSET, 0x00);	// Per leggere Secure
	*strf = END;				// in quanto non termina con END
        if((stri = strstr(buffer + OFFSET, token))) {
                stri = stri + strlen(token);
                strf = strchr(stri, END);
                *strf = 0x00;
        }
                else return(NULL);
        return(stri);
}

