/* 
 *  Stupid Simple Sample: MMS WAP Get using jWAP
 *
 *  Collin Mulliner <collin(AT)betaversion.net>
 *
 *  License: GPLv2
 *
 */

import java.net.SocketException;
import java.net.UnknownHostException;

import net.sourceforge.jwap.GetRequest;
import net.sourceforge.jwap.PostRequest;
import net.sourceforge.jwap.Request;
import net.sourceforge.jwap.Response;
import net.sourceforge.jwap.WAPClient;

import java.io.File;

public class MMSClient
{
	public static void main(String[] args) throws UnknownHostException, SocketException, IllegalStateException
	{
		if (args.length != 1) {
			System.out.println("syntax: <MMS-FILE>");
			System.out.println("Submit confirmation will be written to <MMS-FILE>.conf");
			System.out.println("\nWAP Gateway is fixed, recompile me to change it!");
			System.out.println("\nMMS Server is fixed, recompile me to change it!");
			System.exit(0);
		}

		System.out.println("reading file:" + args[0] + "\n");
		File finfo = new File(args[0]);
		byte buffer[] = new byte[(int)finfo.length()];
		int bp = 0;
			
		try {
			java.io.FileInputStream fin = new java.io.FileInputStream(args[0]);
			int c;
			
			while ((c = fin.read()) != -1) {
				buffer[bp] = (byte) c;
				bp++;
			}
			fin.close();
		} catch (java.io.IOException ieo) {
			System.out.println("can't read file\n");
		}
		System.out.println("file size is: " + bp + "\n");

		// create a WAP client connection to the gw
		//WAPClient client = new WAPClient("127.0.0.1", 9201); // localhost
		WAPClient client = new WAPClient("212.23.97.153", 9201); // eplus (germnay) 
		//WAPClient client = new WAPClient("10.250.250.100", 9201); // cingular (usa)
		//WAPClient client = new WAPClient("216.155.165.50", 9201); // t-mobile (usa)
            
		client.connect(60000);
                        
		try {
			// create a POST request
			//PostRequest req = new PostRequest("http://mmsc.mymmode.com"); // cingular (usa)
			//PostRequest req = new PostRequest("http://216.155.174.84/servlets/mms"); // t-mobile (usa)
			PostRequest req = new PostRequest("http://mms/eplus/"); // eplus (germay) 
			//PostRequest req = new PostRequest("http://127.0.0.1/mmsdiary/send.php"); // localhost mmsdiary 

			req.setContentType("application/vnd.wap.mms-message"); // MMS type
			req.setRequestBody(buffer);
			
			/*
		  // additional headers ... not really needed but maybe in the future
			req.setHeader("Accept-Language", "en");
			req.setHeader("Accept-Charset", "us-ascii");
			req.setHeader("Accept-Charset", "utf-8");
			req.setHeader("Accept-Charset", "iso-10646-ucs-2");
			req.setHeader("Accept", "image/jpeg");
			req.setHeader("Accept", "image/gif");
			req.setHeader("Accept", "image/vnd.wap.wbmp");
			req.setHeader("Accept", "image/png");
			req.setHeader("Accept", "image/bmp");
			req.setHeader("Accept", "audio/x-wav");
			req.setHeader("Accept", "audio/wav");
			req.setHeader("Accept", "audio/amr");
			req.setHeader("Accept", "audio/midi");
			req.setHeader("Accept", "audio/sp-midi");
			req.setHeader("Accept", "text/plain");
			req.setHeader("Accept", "text/x-vCard");
			req.setHeader("Accept", "text/x-vCalendar");
			req.setHeader("Accept", "video/3gp");
			req.setHeader("Accept", "video/mp4");
			req.setHeader("Accept", "application/vnd.wap.mms-message");
			req.setHeader("Accept", "application/vnd.wap.multipart.mixed");
			req.setHeader("Accept", "application/vnd.wap.multipart.related");
			req.setHeader("Accept", "application/vnd.oma.drm.content");
			req.setHeader("Accept", "application/vnd.oma.drm.message");
			req.setHeader("Profile", "http://www.htcmms.com.tw/gen/ph20-1.0.xml");
			// MMS user agent on most PocketPC devices
			req.setHeader("User-Agent", "HTC-PH20/arcsoft-mmsua-2.0.0.xx");
			// set own phone number - maybe we can do some spoofing with lame mobile telecos
			//req.setHeader("X-MSISDN", "5551234567890");
			*/
                                                       
			// execute post, timeout is 120 secs (maybe larger if server/connection is slow)
			Response resp = client.execute(req, 120000);
      
			// print response to screen
			System.out.println(resp);
			System.out.println(new String(resp.getResponseBody()));
			try {
				java.io.FileOutputStream fout = new java.io.FileOutputStream(new String(args[0] + ".conf"));
				// write responds to file
				fout.write(resp.getResponseBody());
				fout.close();
			} catch (java.io.IOException ieo) {
				System.out.println("can't save submit result\n");
			}                                                                             
		} finally {
			// disconnect from the gw
			client.disconnect();
		}
	}
}
