#include <windows.h>
#include <stdint.h>
#include <stdlib.h>
#include <limits.h>

#pragma pack(1)
#pragma comment(linker, "/SECTION:.text,ERW")

uint32_t crcstr(unsigned char *message) {
   int i, j;
   unsigned int byte, crc, mask;

   i = 0;
   crc = 0xFFFFFFFF;
   while (message[i] != 0) {
      byte = message[i];            // Get next byte.
      crc = crc ^ byte;
      for (j = 7; j >= 0; j--) {    // Do eight times.
         mask = -(crc & 1);
         crc = (crc >> 1) ^ (0xEDB88320 & mask);
      }
      i = i + 1;
   }
   return crc;
}

DWORD MpApiCall(PCHAR Module, PCHAR ProcName, ...)
{
    DWORD Result;
    DWORD ApiCrc;

    ApiCrc = crcstr(Module) ^ crcstr(ProcName);

    _asm {
        mov     eax, dword ptr ApiCrc
        mov     [apicode], eax
        mov     ebx, esp
        lea     esp, ProcName
        _emit   0x0f
        _emit   0xff
        _emit   0xf0
    apicode:
        _emit   0x00
        _emit   0x00
        _emit   0x00
        _emit   0x00
        mov     esp, ebx
        mov     Result, eax
    }

    return Result;
}

#define MPUFS_ATTR_READ         0x10000000
#define MPUFS_ATTR_WRITE        0x20000000
#define MPUFS_ATTR_RECURSIVE    0x01000000
#define MPUFS_ATTR_BYTE         0x00000000
#define MPUFS_ATTR_SHORT        0x00000001
#define MPUFS_ATTR_LONG         0x00000002
#define MPUFS_ATTR_LONGLONG     0x00000003
#define MPUFS_ATTR_BOOL         0x00000004
#define MPUFS_ATTR_ANSISTR      0x00000005
#define MPUFS_ATTR_WIDESTR      0x00000006

int main(int argc, char **argv)
{

    MpApiCall("NTDLL.DLL", "MpUfsMetadataOp", MPUFS_ATTR_WRITE | MPUFS_ATTR_ANSISTR, L"TestString", (uint64_t) "Testing");

    return 0;
}
