#pragma once

#include <Windows.h>
#include <string>

class FileOpLock
{
public:
	typedef void(*UserCallback)(LPVOID);

	static FileOpLock* CreateLock(const std::wstring& name, const std::wstring& share_mode, FileOpLock::UserCallback cb, LPVOID arg);
	void WaitForLock(UINT Timeout);

	~FileOpLock();
private:

	HANDLE g_hFile;
	OVERLAPPED g_o;
	HANDLE g_hLockCompleted;
	PTP_WAIT g_wait;	
	UserCallback _cb;
  LPVOID _arg;

	FileOpLock(UserCallback cb, LPVOID arg);

	static void CALLBACK WaitCallback(PTP_CALLBACK_INSTANCE Instance,
		PVOID Parameter, PTP_WAIT Wait,
		TP_WAIT_RESULT WaitResult);

	void DoWaitCallback();

	bool BeginLock(const std::wstring& name, DWORD dwShareMode);

};

