/*
 *  detect-watermark-encodings.c
 *
 *  Written by Jari Ruusu, February 10 2004
 *
 *  Copyright 2004 by Jari Ruusu.
 *  Redistribution of this file is permitted under the GNU GPL
 *
 *  Usage:
 *  dd if=/dev/hda999 bs=64k | ./detect-watermark-encodings
 *
 *  Program reads encrypted data from standard input and writes human
 *  readable summary of detected watermark encodings to standard output.
 *
 *  Credits: Markku-Juhani O. Saarinen discovered this exploit.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

unsigned long found[32];
unsigned char buf[1024];
unsigned long long bytes = 0;

int main(int argc, char **argv)
{
    int x, y;

    memset(found, 0, sizeof(found));
    do {
        if(fread(buf, 1024, 1, stdin) != 1) break;
        bytes += 1024;
        y = 0;
        do {
            /* no encoding if ciphertexts do not match */
            if(memcmp(&buf[y] , &buf[y + 512], 16)) break;
            /* if ciphertext is same repeated byte, assume  */
            /* that block was newer written with ciphertext */
            for(x = 1; x < 16; x++) {
                if(buf[y + x] != buf[y]) break;
            }
            if(x == 16) break;
            /* found watermark encoding */
            y += 16;
        } while(y < 512);
        if(y) {
            found[(y >> 4) - 1] += 1;
	}
    } while(1);
    printf("%llu bytes scanned\n", bytes);
    y = 1;
    for(x = 0; x < 32; x++) {
        if(found[x]) {
            printf("watermark encoding %d, count %lu\n", x + 1, found[x]);
            y = 0;
        }
    }
    if(y) {
        printf("no watermark encodings found\n");
    }
    exit(0);
}
