# Generated by Django 2.2.17 on 2021-01-19 19:52

from django.db import migrations, models
import django.db.models.deletion
import multiselectfield.db.fields
import logging
logger = logging.getLogger(__name__)


class Migration(migrations.Migration):

    def set_risk_accepted_flag_on_findings(apps, schema_editor):
        # We can't import the models directly as it may be a newer
        # version than this migration expects. We use the historical version.
        logger.info('Setting risk_accepted flag on findings that have an existing risk acceptance.')

        accepted_findings = apps.get_model('dojo', 'Finding').objects.filter(risk_acceptance__isnull=False)

        # logger.debug(accepted_findings.query)

        logger.info('found %i findings', accepted_findings.count())

        # bulk update is fast and we don't need any dedupe or other signals triggered by save()
        accepted_findings.update(risk_accepted=True)

        logger.info('marked %i findings as risk accepted', accepted_findings.count())

    dependencies = [
        ('dojo', '0068_file_upload'),
    ]

    operations = [
        migrations.AddField(
            model_name='finding',
            name='risk_accepted',
            field=models.BooleanField(default=False, help_text='Denotes if this finding has been marked as an accepted risk.', verbose_name='Risk Accepted'),
        ),

        migrations.RunPython(set_risk_accepted_flag_on_findings, migrations.RunPython.noop),

        migrations.RemoveField(
            model_name='engagement',
            name='risk_path',
        ),
        migrations.RemoveField(
            model_name='risk_acceptance',
            name='compensating_control',
        ),
        migrations.AddField(
            model_name='finding',
            name='sla_start_date',
            field=models.DateField(blank=True, help_text="(readonly)The date used as start date for SLA calculation. Set by expiring risk acceptances. Empty by default, causing a fallback to 'date'.", null=True, verbose_name='SLA Start Date'),
        ),
        migrations.AddField(
            model_name='jira_project',
            name='risk_acceptance_expiration_notification',
            field=models.BooleanField(blank=True, default=False, verbose_name='Send Risk Acceptance expiration notifications as comment?'),
        ),
        migrations.AddField(
            model_name='notifications',
            name='risk_acceptance_expiration',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of (upcoming) Risk Acceptance expiries', max_length=24, verbose_name='Risk Acceptance Expiration'),
        ),
        migrations.AddField(
            model_name='product',
            name='enable_full_risk_acceptance',
            field=models.BooleanField(default=True, help_text='Allows full risk acceptance using a risk acceptance form, expiration date, uploaded proof, etc.'),
        ),
        migrations.AddField(
            model_name='product',
            name='enable_simple_risk_acceptance',
            field=models.BooleanField(default=False, help_text='Allows simple risk acceptance by checking/unchecking a checkbox.'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='decision',
            field=models.CharField(choices=[('A', 'Accept (The risk is acknowledged, yet remains)'), ('V', 'Avoid (Do not engage with whatever creates the risk)'), ('M', 'Mitigate (The risk still exists, yet compensating controls make it less of a threat)'), ('F', 'Fix (The risk is eradicated)'), ('T', 'Transfer (The risk is transferred to a 3rd party)')], default='A', help_text='Risk treatment decision by risk owner', max_length=2),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='decision_details',
            field=models.TextField(blank=True, default=None, help_text='If a compensating control exists to mitigate the finding or reduce risk, then list the compensating control(s).', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='expiration_date_handled',
            field=models.DateTimeField(blank=True, default=None, help_text='(readonly) When the risk acceptance expiration was handled (manually or by the daily job).', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='expiration_date_warned',
            field=models.DateTimeField(blank=True, default=None, help_text='(readonly) Date at which notice about the risk acceptance expiration was sent.', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='reactivate_expired',
            field=models.BooleanField(default=True, help_text='Reactivate findings when risk acceptance expires?', verbose_name='Reactivate findings on expiration'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='recommendation',
            field=models.CharField(choices=[('A', 'Accept (The risk is acknowledged, yet remains)'), ('V', 'Avoid (Do not engage with whatever creates the risk)'), ('M', 'Mitigate (The risk still exists, yet compensating controls make it less of a threat)'), ('F', 'Fix (The risk is eradicated)'), ('T', 'Transfer (The risk is transferred to a 3rd party)')], default='F', help_text='Recommendation from the security team.', max_length=2, verbose_name='Security Recommendation'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='recommendation_details',
            field=models.TextField(blank=True, help_text='Explanation of security recommendation', null=True, verbose_name='Security Recommendation Details'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='restart_sla_expired',
            field=models.BooleanField(default=False, help_text='When enabled, the SLA for findings is restarted when the risk acceptance expires.', verbose_name='Restart SLA on expiration'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='risk_acceptance_form_default_days',
            field=models.IntegerField(blank=True, default=180, help_text='Default expiry period for risk acceptance form.', null=True),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='risk_acceptance_notify_before_expiration',
            field=models.IntegerField(blank=True, default=10, help_text='Notify X days before risk acceptance expires. Leave empty to disable.', null=True, verbose_name='Risk acceptance expiration heads up days'),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='sla_breach',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of (upcoming) SLA breaches', max_length=24, verbose_name='SLA breach'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='accepted_by',
            field=models.CharField(blank=True, default=None, help_text='The person that accepts the risk, can be outside of DefectDojo.', max_length=200, null=True, verbose_name='Accepted By'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='expiration_date',
            field=models.DateTimeField(blank=True, default=None, help_text='When the risk acceptance expires, the findings will be reactivated (unless disabled below).', null=True),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='owner',
            field=models.ForeignKey(help_text='User in DefectDojo owning this acceptance. Only the owner and staff users can edit the risk acceptance.', on_delete=django.db.models.deletion.CASCADE, to='dojo.Dojo_User'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='path',
            field=models.FileField(blank=True, null=True, upload_to='risk/%Y/%m/%d', verbose_name='Proof'),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
    ]
