# Generated by Django 2.2.1 on 2019-08-28 11:14

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


def update_collation(apps, schema_editor):
    print('Database vendor: {}'.format(schema_editor.connection.vendor))
    if not schema_editor.connection.vendor.startswith('mysql'):
        return
    schema_editor.execute('ALTER TABLE dojo_sonarqube_issue CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_bin')


def rollback_collation(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0017_auto_20190827_1421'),
    ]

    operations = [
        migrations.CreateModel(
            name='Sonarqube_Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(help_text='SonarQube issue key', max_length=30, unique=True)),
                ('status', models.CharField(help_text='SonarQube issue status', max_length=20)),
                ('type', models.CharField(help_text='SonarQube issue type', max_length=15)),
            ],
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200),
        ),
        migrations.CreateModel(
            name='Sonarqube_Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sonarqube_project_key', models.CharField(blank=True, max_length=200, null=True, verbose_name='SonarQube Project Key')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product')),
                ('sonarqube_tool_config', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Tool_Configuration', verbose_name='SonarQube Configuration')),
            ],
        ),
        migrations.CreateModel(
            name='Sonarqube_Issue_Transition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('finding_status', models.CharField(max_length=100)),
                ('sonarqube_status', models.CharField(max_length=50)),
                ('transitions', models.CharField(max_length=100)),
                ('sonarqube_issue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Sonarqube_Issue')),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.AddField(
            model_name='finding',
            name='sonarqube_issue',
            field=models.ForeignKey(blank=True, help_text='SonarQube issue', null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Sonarqube_Issue'),
        ),
        migrations.RunPython(update_collation, rollback_collation, atomic=False),
    ]
