package DebBin;
use warnings;
use strict;
use integer;
use DebSrcBin;
our @ISA = ( 'DebSrcBin' );
use AllProv;

our %levels_default = (
  dep  =>  30,
  bdep => 100,
  cfl  =>  40,
  bcfl => 100,
);

our @dep_class = (
  {
    class => 'dep',
    sense => 1,
    xkeys => [
      { xkey => 'xPre-Depends'          , lvl => 50 },
      { xkey => 'xDepends'              , lvl => 40 },
      { xkey => 'xRecommends'           , lvl => 30 },
      { xkey => 'xSuggests'             , lvl => 20 },
      { xkey => 'renh'                  , lvl => 10 },
    ],
  },
  {
    class => 'bdep',
    sense => 1,
    xkeys => [
      { xkey => 'xBuild-Depends'        , lvl => 40 },
      { xkey => 'xBuild-Depends-Indep'  , lvl => 30 },
    ],
  },
  {
    class => 'cfl',
    sense => 0,
    xkeys => [
      { xkey => 'xConflicts'            , lvl => 40 },
      { xkey => 'xReplaces'             , lvl => 30 },
    ],
  },
  {
    class => 'bcfl',
    sense => 0,
    xkeys => [
      { xkey => 'xBuild-Conflicts'      , lvl => 40 },
      { xkey => 'xBuild-Conflicts-Indep', lvl => 30 },
    ],
  },
);

# Instantiate and initialize a new DebBin object.
sub new {
  my $class = shift;
  my $bin1  = DebSrcBin->new( @_ );
  bless $bin1, $class if defined $bin1;
  return $bin1;
}

# Check whether the DebBin's dependencies are fully satisfied at the
# given selection level.  Return an empty list if okay; a list of hashes
# explaining the errors if not.
sub are_all_deps_satisfied {
  my( $bin1, $prov, $levels, $sel ) = @_;
  my @err;
  for my $dep_class ( @dep_class ) {
    my $sense  = $dep_class->{sense};
    my $class  = $dep_class->{class};
    my $lvl_th = defined( $levels->{$class} )
      ? $levels->{$class} : $levels_default{$class};
    for my $xkeys ( @{ $dep_class->{xkeys} } ) {
      my $xkey = $xkeys->{xkey};
      my $lvl  = $xkeys->{lvl};
      $lvl >= $lvl_th && defined( $bin1->{$xkey} ) or next;
      my $dep0 = $bin1->{$xkey};
      for my $altern ( @$dep0 ) {
        (
          $sense xor
          $prov->check_altern( $altern, $sel )
        ) and push @err, {
          pname        => $bin1->{Package},
          relationship => $xkey,
          altern       => $altern,
        };
      }
    }
  }
  return @err;
}

1;

