"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeMarkerField = exports.editorSupportField = exports.clearTypeMarkersEffect = exports.addTypeMarkerEffect = void 0;
var _state = require("@codemirror/state");
var _view = require("@codemirror/view");
var _editorSupport = require("@neo4j-cypher/editor-support");
const editorSupportField = _state.StateField.define({
  create() {
    return new _editorSupport.CypherEditorSupport();
  },
  update(editorSupport, tr) {
    return editorSupport;
  }
});
exports.editorSupportField = editorSupportField;
const addTypeMarkerEffect = _state.StateEffect.define();
exports.addTypeMarkerEffect = addTypeMarkerEffect;
const clearTypeMarkersEffect = _state.StateEffect.define();
exports.clearTypeMarkersEffect = clearTypeMarkersEffect;
const typeMarkerField = _state.StateField.define({
  create() {
    return _view.Decoration.none;
  },
  update(typeMarkers, tr) {
    typeMarkers = typeMarkers.map(tr.changes);
    for (let e of tr.effects) {
      if (e.is(clearTypeMarkersEffect)) {
        typeMarkers = _view.Decoration.none;
      } else if (e.is(addTypeMarkerEffect)) {
        if (e.value.from !== e.value.to) {
          typeMarkers = typeMarkers.update({
            add: [_view.Decoration.mark({
              class: "cm-p-" + e.value.type
            }).range(e.value.from, e.value.to)]
          });
        }
      }
    }
    return typeMarkers;
  },
  provide: f => _view.EditorView.decorations.from(f)
});
exports.typeMarkerField = typeMarkerField;